/*
 * Decompiled with CFR 0.152.
 */
package me.duart.cucm;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import me.duart.cucm.commands.ReloadCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.command.UnknownCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class CustomUnknownCommandMessage
extends JavaPlugin
implements Listener {
    private final MiniMessage mini = MiniMessage.miniMessage();
    private final CopyOnWriteArrayList<Component> cache = new CopyOnWriteArrayList();
    private boolean useList;

    public void onEnable() {
        this.saveDefaultConfig();
        this.rebuildCache();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Bukkit.getCommandMap().register("cucmreload", (Command)new ReloadCommand(this));
    }

    @EventHandler
    public void onUnknownCommand(@NotNull UnknownCommandEvent event) {
        if (this.useList && !this.cache.isEmpty()) {
            event.message(this.cache.get(ThreadLocalRandom.current().nextInt(this.cache.size())));
        } else if (!this.cache.isEmpty()) {
            event.message(this.cache.get(0));
        }
    }

    public void rebuildCache() {
        this.cache.clear();
        FileConfiguration config = this.getConfig();
        this.useList = config.getBoolean("use-multiple-messages", false);
        if (this.useList) {
            for (String raw : config.getStringList("message-list")) {
                this.cache.add(this.mini.deserialize((Object)raw));
            }
        } else {
            this.cache.add(this.mini.deserialize((Object)config.getString("single-message", "<red>Unknown Command, please use <gold>/help</gold> for more information.")));
        }
    }
}

