package io.github.diiiaz.better_hammers.api;

// Copied and/or modified from: "https://github.com/Draylar/magna/blob/1.20.1/src/main/java/dev/draylar/magna/api/BlockBreaker.java"

import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3468;
import java.util.ArrayList;
import java.util.List;

public class BlockBreaker {

    public static void breakInRadius(class_1937 world, class_1657 player, int radius, int depth, BlockFinder finder, BreakValidator breakValidator, BlockProcessor smelter, boolean damageTool) {
        if (world.field_9236) { return; }

        class_3225 interactionManager = ((class_3222) player).field_13974;
        ((PlayerInteractionManagerExtension) interactionManager).betterHammers$setMining(true);

        List<class_2338> brokenBlocks = finder.findPositions(world, player, radius, depth);
        for(class_2338 pos : brokenBlocks) {
            class_2680 state = world.method_8320(pos);
            class_2586 blockEntity = world.method_8320(pos).method_31709() ? world.method_8321(pos) : null;

            if (!breakValidator.canBreak(world, pos) || state.method_26215()) { continue; }

            state.method_26204().method_9576(world, pos, state, player);
            if (!interactionManager.method_14266(pos)) { continue; }

            boolean result = PlayerBlockBreakEvents.BEFORE.invoker().beforeBlockBreak(world, player, pos, state, world.method_8321(pos));
            if(!result) { continue; }

            boolean bl = world.method_8650(pos, false);
            if (bl) {
                state.method_26204().method_9585(world, pos, state);
            }

            if (player.method_7337()) { continue; }

            class_243 offsetPos = new class_243(pos.method_10263() + .5, pos.method_10264() + .5, pos.method_10260() + .5);

            List<class_1799> droppedStacks = class_2248.method_9609(state, (class_3218) world, pos, blockEntity, player, player.method_6047());
            List<class_1799> processed = new ArrayList<>();

            droppedStacks.forEach(stack -> processed.add(smelter.process(player.method_31548().method_7391(), stack)));

            dropItems(player, world, processed, offsetPos);
            state.method_26180((class_3218) world, pos, player.method_6047(), true);

            if (!damageTool) { continue; }

            class_1799 itemStack = player.method_6047();
            boolean usingEffectiveTool = player.method_7305(state);
            itemStack.method_7952(world, state, pos, player);

            if (!usingEffectiveTool) { continue; }

            player.method_7259(class_3468.field_15427.method_14956(state.method_26204()));
            player.method_7322(0.005F);
        }
        ((PlayerInteractionManagerExtension) (interactionManager)).betterHammers$setMining(false);
    }

    private static void dropItems(class_1657 player, class_1937 world, List<class_1799> stacks, class_243 pos) {
        for(class_1799 stack : stacks) {
            if (stack.method_7960()) { continue; }
            class_1542 itemEntity = new class_1542(world, pos.method_10216(), pos.method_10214(), pos.method_10215(), stack);
            world.method_8649(itemEntity);
        }
    }
}