package io.github.diiiaz.better_hammers.api;

import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

/**
 * Provides information on whether a {@link class_2680} can be broken.
 */
@FunctionalInterface
public interface BreakValidator {

    /**
     * Implementers should return whether the given {@link class_2680} can be broken.
     *
     * @param view  {@link class_1922} of the {@link class_2680}
     * @param pos  {@link class_2338} of the {@link class_2680}
     * @return  whether the given {@link class_2680} can be broken
     */
    boolean canBreak(class_1922 view, class_2338 pos);
}