package io.github.diiiaz.better_hammers.mixin;

// Copied and/or modified from: "https://github.com/Draylar/magna/blob/1.20.1/src/main/java/dev/draylar/magna/mixin/BlockMixin.java"

import io.github.diiiaz.better_hammers.api.BlockProcessor;
import io.github.diiiaz.better_hammers.api.HammerTool;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

@Mixin(class_2248.class)
public abstract class BlockMixin {

    @Shadow public static void dropStack(class_1937 world, class_2338 pos, class_1799 stack) { }
    @Shadow public static List<class_1799> getDroppedStacks(class_2680 state, class_3218 world, class_2338 pos, class_2586 blockEntity, class_1297 entity, class_1799 stack) { return null; }

    /**
     * Covers an edge-case where shifting and breaking a block with a tool wouldn't apply processors.
     *
     * @param state        state of the block that was broken
     * @param world        world the break occurred in
     * @param pos          position the broke occurred at
     * @param blockEntity  blockEntity being broken, if any
     * @param entity       entity causing the drops, if any
     * @param tool         tool used to break the block
     * @param ci           mixin callback info
     */
    @Inject(
            method = "dropStacks(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/entity/BlockEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)V",
            at = @At("HEAD"),
            cancellable = true
    )
    private static void processItems(class_2680 state, class_1937 world, class_2338 pos, class_2586 blockEntity, class_1297 entity, class_1799 tool, CallbackInfo ci) {
        if (world.field_9236 || !(tool.method_7909() instanceof HammerTool hammerItem) || !(entity instanceof class_1657)) { return; }

        BlockProcessor processor = hammerItem.getProcessor(world, (class_1657) entity, pos, tool);

        List<class_1799> dropped = getDroppedStacks(state, (class_3218) world, pos, blockEntity, entity, tool);
        if(dropped != null) {
            dropped.forEach((drop) -> dropStack(world, pos, processor.process(tool, drop)));
        }

        state.method_26180((class_3218) world, pos, tool, true);
        ci.cancel();
    }
}