package io.github.diiiaz.better_hammers.mixin;

// Copied and/or modified from: "https://github.com/Draylar/magna/blob/1.20.1/src/main/java/dev/draylar/magna/mixin/ServerPlayerInteractionManagerMixin.java"

import io.github.diiiaz.better_hammers.api.PlayerInteractionManagerExtension;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import io.github.diiiaz.better_hammers.api.HammerTool;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

// This class has a lower priority than default so it runs after claim mods/FAPI checks for block breaking validity.
@Mixin(value = class_3225.class, priority = 1001)
public class ServerPlayerInteractionManagerMixin implements PlayerInteractionManagerExtension {

    @Final
    @Shadow
    protected class_3222 player;
    @Shadow
    protected class_3218 world;

    @Unique private boolean isMining = false;

    @Inject(
            method = "tryBreakBlock",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/block/Block;onBreak(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/entity/player/PlayerEntity;)V"
            ),
            cancellable = true
    )
    private void tryBreak(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        class_1799 heldStack = player.method_6047();

        if (heldStack.method_7909() instanceof HammerTool) {
            // This is to avoid recursion, but the goal is to make sure every block it doesn't override cancelled block breaks using Fabric's callbacks. This was made to support claim mods.
            boolean v = isMining || ((HammerTool) heldStack.method_7909()).attemptBreak(world, pos, player, ((HammerTool) heldStack.method_7909()).getRadius(heldStack), ((HammerTool) heldStack.method_7909()).getProcessor(world, player, pos, heldStack));

            // only cancel if the break was successful
            if(v) { cir.setReturnValue(true); }
        }
    }

    @Override
    public void betterHammers$setMining(boolean mining) {
        this.isMining = mining;
    }
}