package io.github.diiiaz.better_hammers.mixin;

// Copied and/or modified from: "https://github.com/Draylar/magna/blob/1.20.1/src/main/java/dev/draylar/magna/mixin/WorldMixin.java"

import io.github.diiiaz.better_hammers.item.HammerItem;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1937.class)
public abstract class WorldMixin implements class_1936, AutoCloseable {

    @Unique private class_1297 cachedEntity = null;

    @Inject(
            method = "breakBlock",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/World;getFluidState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/fluid/FluidState;"
            )
    )
    private void storeContext(class_2338 pos, boolean drop, class_1297 breakingEntity, int maxUpdateDepth, CallbackInfoReturnable<Boolean> cir) {
        cachedEntity = breakingEntity;
    }

    @Redirect(
            method = "breakBlock",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/World;syncWorldEvent(ILnet/minecraft/util/math/BlockPos;I)V"
            )
    )
    private void cancelSyncWorldEvent(class_1937 world, int eventId, class_2338 pos, int data) {
        class_2680 blockState = this.method_8320(pos);

        if(cachedEntity instanceof class_1657 player) {
            class_1799 heldStack = player.method_6047();

            if(heldStack.method_7909() instanceof HammerItem) { return; }
        }

        this.method_20290(2001, pos, class_2248.method_9507(blockState));
    }
}