package io.github.diiiaz.better_hammers.mixin;

// Copied and/or modified from: "https://github.com/Draylar/magna/blob/1.20.1/src/main/java/dev/draylar/magna/mixin/WorldRendererMixin.java"

import io.github.diiiaz.better_hammers.api.ToolRadiusCallback;
import io.github.diiiaz.better_hammers.api.HammerTool;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_761;
import org.spongepowered.asm.mixin.gen.Invoker;

import java.util.ArrayList;
import java.util.List;

@Mixin(class_761.class)
@Environment(EnvType.CLIENT)
public class WorldRendererMixin {

    @Shadow
    @Final
    private class_310 client;

    @Shadow
    private class_638 world;

    @Inject(at = @At("HEAD"), method = "drawBlockOutline", cancellable = true)
    private void drawBlockOutline(class_4587 stack, class_4588 vertexConsumer, class_1297 entity, double d, double e, double f, class_2338 blockPos, class_2680 blockState, CallbackInfo ci) {

        if (this.client.field_1724 == null || this.client.field_1687 == null) { return; }

        class_1799 heldStack = this.client.field_1724.method_31548().method_7391();
        if (!(heldStack.method_7909() instanceof HammerTool tool)) { return; }
        if (!(client.field_1765 instanceof class_3965 crosshairTarget)) { return; }

        class_2338 crosshairPos = crosshairTarget.method_17777();
        class_2680 crosshairState = client.field_1687.method_8320(crosshairPos);

        if (crosshairState.method_26215() || !client.field_1687.method_8621().method_11952(crosshairPos) || !tool.isBlockValidForBreaking(world, crosshairPos, heldStack)) { return; }

        int radius = ToolRadiusCallback.EVENT.invoker().getRadius(heldStack, tool.getRadius(heldStack));
        List<class_2338> positions = tool.getBlockFinder().findPositions(world, client.field_1724, radius, tool.getDepth(heldStack));
        List<class_265> outlineShapes = new ArrayList<>();
        outlineShapes.add(class_259.method_1073());

        for (class_2338 position : positions) {
            if (!tool.isBlockValidForBreaking(world, position, heldStack)) { continue; }

            class_2338 diffPos = position.method_10059(crosshairPos);
            class_2680 offsetShape = world.method_8320(position);

            if (!offsetShape.method_26215()) {
                outlineShapes.add(class_259.method_1077().method_1096(diffPos.method_10263(), diffPos.method_10264(), diffPos.method_10260()));
            }
        }

        outlineShapes.forEach(shape -> drawCuboidShapeOutline(
                stack,
                vertexConsumer,
                shape,
                (double) crosshairPos.method_10263() - d,
                (double) crosshairPos.method_10264() - e,
                (double) crosshairPos.method_10260() - f,
                0.0F,
                0.0F,
                0.0F,
                0.4F));
        ci.cancel();
    }

    @Invoker("drawCuboidShapeOutline")
    public static void drawCuboidShapeOutline(class_4587 matrices, class_4588 vertexConsumer, class_265 shape, double offsetX, double offsetY, double offsetZ, float red, float green, float blue, float alpha) {
        throw new AssertionError();
    }
}