/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings;

import com.pedestriamc.strings.api.APIRegistrar;
import com.pedestriamc.strings.api.StringsPlatform;
import com.pedestriamc.strings.api.channel.data.BuildableRegistrar;
import com.pedestriamc.strings.api.event.StringsReloader;
import com.pedestriamc.strings.bukkit.Metrics;
import com.pedestriamc.strings.charts.SimplePie;
import com.pedestriamc.strings.chat.ChannelManager;
import com.pedestriamc.strings.chat.Mentioner;
import com.pedestriamc.strings.configuration.Configuration;
import com.pedestriamc.strings.directmessage.PlayerDirectMessenger;
import com.pedestriamc.strings.impl.BukkitMessenger;
import com.pedestriamc.strings.impl.StringsImpl;
import com.pedestriamc.strings.log.LogManager;
import com.pedestriamc.strings.manager.ClassRegistryManager;
import com.pedestriamc.strings.manager.FileManager;
import com.pedestriamc.strings.misc.AutoBroadcasts;
import com.pedestriamc.strings.misc.ServerMessages;
import com.pedestriamc.strings.placeholder.StringsPlaceholderExpansion;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import com.pedestriamc.strings.user.util.YamlUserUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Collection;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class Strings
extends JavaPlugin
implements StringsPlatform {
    public static final String VERSION = "1.6";
    public static final short VERSION_NUM = 6;
    public static final int METRICS_ID = 22597;
    public static final String DISTRIBUTOR = "modrinth";
    private boolean usingPlaceholderAPI = false;
    private boolean isPaper = false;
    private boolean usingVault;
    private boolean usingLuckPerms = false;
    private BukkitAudiences adventure;
    private FileManager fileManager;
    private UserUtil userUtil;
    private Chat chat = null;
    private ServerMessages serverMessages;
    private PlayerDirectMessenger playerDirectMessenger;
    private StringsImpl stringsImpl;
    private Mentioner mentioner;
    private UUID apiUUID;
    private BukkitMessenger messenger;
    private ChannelManager channelLoader;
    private LogManager logManager;
    private Configuration configClass;

    public void onLoad() {
        this.info("Loading...");
        this.fileManager = new FileManager(this);
        this.info("FileManager loaded.");
        this.userUtil = new YamlUserUtil(this);
        this.info("UserUtil loaded.");
        BuildableRegistrar.register(this);
        this.determineEnvironment();
        this.instantiateObjects();
        this.registerAPI();
    }

    public void onEnable() {
        this.adventure = BukkitAudiences.create((Plugin)this);
        this.logManager = new LogManager(this);
        this.setupVault();
        this.channelLoader.loadChannels();
        ClassRegistryManager.register(this);
        this.checkIfReload();
        this.checkForUpdate();
        this.instantiateObjectsTwo();
        this.registerPlaceholders();
        this.loadMetrics();
        this.info("Enabled");
    }

    public void onDisable() {
        this.logOutAll();
        this.userUtil = null;
        this.serverMessages = null;
        this.playerDirectMessenger = null;
        this.channelLoader = null;
        this.mentioner = null;
        this.logManager = null;
        this.fileManager = null;
        HandlerList.unregisterAll((Plugin)this);
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.stringsImpl = null;
        if (this.adventure != null) {
            this.adventure.close();
            this.adventure = null;
        }
        try {
            APIRegistrar.unregister(this.apiUUID);
        }
        catch (IllegalStateException | SecurityException runtimeException) {
            // empty catch block
        }
        this.info("Disabled");
    }

    public void reload() {
        this.onDisable();
        this.reloadConfig();
        this.onLoad();
        this.onEnable();
        this.getServer().getPluginManager().callEvent((Event)StringsReloader.createEvent());
    }

    private void loadMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 22597);
        metrics.addCustomChart(new SimplePie("distributor", () -> DISTRIBUTOR));
        metrics.addCustomChart(new SimplePie("using_stringsapi", () -> String.valueOf(APIRegistrar.isAPIUsed())));
        metrics.addCustomChart(new SimplePie("using_stringsmoderation_expansion", () -> String.valueOf(this.getServer().getPluginManager().getPlugin("StringsModeration") != null)));
    }

    private void logOutAll() {
        this.userUtil.getUsers().forEach(User::logOff);
    }

    private void determineEnvironment() {
        if (this.getConfig().getBoolean("placeholder-api") && this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.info("PlaceholderAPI detected.");
            this.usingPlaceholderAPI = true;
        }
        if (this.getServer().getPluginManager().getPlugin("LuckPerms") != null) {
            this.usingLuckPerms = true;
        }
        try {
            Class.forName("io.papermc.paper.event.player.AsyncChatEvent");
            this.isPaper = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void instantiateObjects() {
        this.configClass = new Configuration(this.getConfig());
        this.messenger = new BukkitMessenger(this.fileManager.getMessagesFileConfig());
        this.playerDirectMessenger = new PlayerDirectMessenger(this);
        this.channelLoader = new ChannelManager(this);
        this.serverMessages = new ServerMessages(this);
        this.mentioner = new Mentioner(this);
    }

    private void instantiateObjectsTwo() {
        new AutoBroadcasts(this);
    }

    private void setupVault() {
        try {
            RegisteredServiceProvider serviceProvider = this.getServer().getServicesManager().getRegistration(Chat.class);
            if (serviceProvider == null) {
                this.info("Vault not found, using built in methods.");
                this.usingVault = false;
            } else {
                this.chat = (Chat)serviceProvider.getProvider();
                this.usingVault = true;
                this.info("Vault found.");
            }
        }
        catch (NoClassDefFoundError a) {
            this.warning("Vault not found, using built in methods.");
            this.usingVault = false;
        }
    }

    private void checkIfReload() {
        Collection players = this.getServer().getOnlinePlayers();
        if (!players.isEmpty()) {
            for (Player p : players) {
                this.userUtil.loadUser(p.getUniqueId());
            }
        }
    }

    private void registerPlaceholders() {
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new StringsPlaceholderExpansion(this).register();
        }
    }

    private void checkForUpdate() {
        try {
            HttpsURLConnection connection = (HttpsURLConnection)URI.create("https://www.wiicart.net/strings/version.txt").toURL().openConnection();
            connection.setRequestMethod("GET");
            String raw = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
            short latest = Short.parseShort(raw);
            if (latest > 6) {
                this.getServer().getLogger().info("+------------[Strings]------------+");
                this.getServer().getLogger().info("|    A new update is available!   |");
                this.getServer().getLogger().info("|          Download at:           |");
                this.getServer().getLogger().info("|   https://wiicart.net/strings   |");
                this.getServer().getLogger().info("+---------------------------------+");
            }
        }
        catch (IOException a) {
            this.warning("Unable to check for updates.");
        }
    }

    private void registerAPI() {
        this.apiUUID = UUID.randomUUID();
        this.stringsImpl = new StringsImpl(this);
        try {
            APIRegistrar.register(this.stringsImpl, this, this.apiUUID);
        }
        catch (IllegalStateException a) {
            this.info("Failed to register StringsAPI");
        }
    }

    public void async(Runnable runnable) {
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, runnable);
    }

    @NotNull
    public FileManager files() {
        return this.fileManager;
    }

    @NotNull
    public UserUtil users() {
        return this.userUtil;
    }

    public Chat getVaultChat() {
        return this.chat;
    }

    public boolean isUsingPlaceholderAPI() {
        return this.usingPlaceholderAPI;
    }

    public boolean isUsingVault() {
        return this.usingVault;
    }

    public boolean isUsingLuckPerms() {
        return this.usingLuckPerms;
    }

    public boolean isPaper() {
        return this.isPaper;
    }

    public Mentioner getMentioner() {
        return this.mentioner;
    }

    public ChannelManager getChannelLoader() {
        return this.channelLoader;
    }

    public ServerMessages getServerMessages() {
        return this.serverMessages;
    }

    public PlayerDirectMessenger getPlayerDirectMessenger() {
        return this.playerDirectMessenger;
    }

    public BukkitMessenger getMessenger() {
        return this.messenger;
    }

    @NotNull
    public BukkitAudiences adventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return this.adventure;
    }

    public Configuration getConfiguration() {
        return this.configClass;
    }

    public void info(@NotNull String message) {
        this.getLogger().info(message);
    }

    public void info(@NotNull Object message) {
        this.info(message.toString());
    }

    public void warning(@NotNull String message) {
        this.getLogger().warning(message);
    }

    public void warning(@NotNull Object message) {
        this.warning(message.toString());
    }
}

