/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.api;

import com.pedestriamc.strings.api.StringsAPI;
import com.pedestriamc.strings.api.StringsModeration;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class StringsProvider {
    private static StringsAPI api;
    private static UUID apiUuid;
    private static boolean invoked;
    private static StringsModeration moderation;

    private StringsProvider() {
    }

    public static StringsAPI get() {
        if (api == null) {
            throw new IllegalStateException("Strings API not initialized.");
        }
        invoked = true;
        return api;
    }

    public static StringsModeration getModeration() {
        if (moderation == null) {
            throw new IllegalStateException("Strings Moderation is not available.");
        }
        invoked = true;
        return moderation;
    }

    public static boolean isEnabled() {
        return api != null;
    }

    static boolean isUsed() {
        return invoked;
    }

    @ApiStatus.Internal
    static void register(@NotNull StringsAPI api, JavaPlugin plugin, UUID uuid) throws IllegalStateException, SecurityException {
        if (StringsProvider.api != null) {
            throw new IllegalStateException("StringsProvider already initialized.");
        }
        if (!StringsProvider.class.getClassLoader().equals(api.getClass().getClassLoader())) {
            throw new SecurityException("Unauthorized attempt to load StringsAPI.");
        }
        apiUuid = uuid;
        StringsProvider.api = api;
        Bukkit.getServer().getServicesManager().register(StringsAPI.class, (Object)StringsProvider.api, (Plugin)plugin, ServicePriority.Highest);
        Bukkit.getLogger().info("[Strings] Strings API loaded.");
    }

    @ApiStatus.Internal
    static void unregister(UUID uuid) throws IllegalStateException, SecurityException {
        if (api == null) {
            throw new IllegalStateException("StringsProvider uninitialized.");
        }
        if (apiUuid != uuid) {
            throw new SecurityException("Unregister method called with unauthorized UUID.");
        }
        Bukkit.getServer().getServicesManager().unregister(StringsAPI.class, (Object)api);
        api = null;
        Bukkit.getLogger().info("[Strings] Strings API unloaded.");
    }

    @ApiStatus.Internal
    static void registerModeration(StringsModeration moderation) {
        StringsProvider.moderation = moderation;
    }

    @ApiStatus.Internal
    static void unregisterModeration() {
        moderation = null;
    }

    static {
        invoked = false;
    }
}

