/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.api.channel;

import com.pedestriamc.strings.api.channel.Membership;
import com.pedestriamc.strings.api.channel.Type;
import com.pedestriamc.strings.api.channel.data.ChannelBuilder;
import com.pedestriamc.strings.api.channel.data.LocalChannelBuilder;
import com.pedestriamc.strings.api.channel.local.Locality;
import com.pedestriamc.strings.api.user.StringsUser;
import java.util.Map;
import java.util.Set;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public interface Channel
extends Comparable<Channel> {
    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static ChannelBuilder builder(@NotNull String name, @NotNull String format, @NotNull Membership membership) {
        return new ChannelBuilder(name, format, membership);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static <T> LocalChannelBuilder<T> localBuilder(@NotNull String name, @NotNull String format, @NotNull Membership membership, Set<Locality<T>> worlds) {
        return new LocalChannelBuilder<T>(name, format, membership, worlds);
    }

    @NotNull
    @Contract(pure=true)
    public String getIdentifier();

    public void sendMessage(@NotNull StringsUser var1, @NotNull String var2);

    @Override
    public int compareTo(@NotNull Channel var1);

    @NotNull
    public Channel resolve(@NotNull StringsUser var1);

    public Set<StringsUser> getRecipients(@NotNull StringsUser var1);

    public Set<StringsUser> getPlayersInScope();

    public void broadcast(@NotNull String var1);

    public void broadcastPlain(@NotNull String var1);

    @NotNull
    public String getFormat();

    @NotNull
    public String getBroadcastFormat();

    public void setFormat(@NotNull String var1);

    @NotNull
    public String getName();

    public void setName(@NotNull String var1);

    @ApiStatus.Obsolete
    public String getDefaultColor();

    @ApiStatus.Obsolete
    public void setDefaultColor(String var1);

    public boolean isUrlFiltering();

    public void setUrlFilter(boolean var1);

    public boolean isProfanityFiltering();

    public void setProfanityFilter(boolean var1);

    public boolean isCooldownEnabled();

    public void setDoCooldown(boolean var1);

    @ApiStatus.Internal
    public void addMember(@NotNull StringsUser var1);

    @ApiStatus.Internal
    public void removeMember(@NotNull StringsUser var1);

    public Set<StringsUser> getMembers();

    @NotNull
    public Type getType();

    public Map<String, Object> getData();

    public Membership getMembership();

    public @Range(from=-2147483648L, to=0x7FFFFFFFL) int getPriority();

    public boolean allows(@NotNull Permissible var1);

    public boolean callsEvents();
}

