/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.api.channel.data;

import com.google.common.base.Preconditions;
import com.pedestriamc.strings.api.annotation.Agnostic;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.channel.Membership;
import com.pedestriamc.strings.api.channel.data.BuilderRegistry;
import com.pedestriamc.strings.api.channel.data.ChannelBuilder;
import com.pedestriamc.strings.api.channel.data.IChannelBuilder;
import com.pedestriamc.strings.api.channel.data.LocalChannelBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@Agnostic
@ApiStatus.Internal
abstract sealed class AbstractChannelBuilder<B extends IChannelBuilder<B>>
implements IChannelBuilder<B>
permits ChannelBuilder, LocalChannelBuilder {
    @NotNull
    private String name;
    @NotNull
    private String format;
    @NotNull
    private Membership membership;
    @Nullable
    private String defaultColor;
    @Nullable
    private String broadcastFormat;
    private @Range(from=-1L, to=0x7FFFFFFFL) int priority;
    private boolean doCooldown;
    private boolean doProfanityFilter;
    private boolean doUrlFilter;
    private boolean callEvent;

    AbstractChannelBuilder(@NotNull String name, @NotNull String format, @NotNull Membership membership) {
        this.name = name;
        this.format = format;
        this.membership = membership;
    }

    @Override
    @Contract(value="_ -> new")
    public Channel build(@NotNull String type) throws IllegalArgumentException {
        return BuilderRegistry.build(this, type);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public B setName(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        this.name = name;
        return (B)this;
    }

    @Override
    @NotNull
    public String getDefaultColor() {
        return this.defaultColor != null ? this.defaultColor : "";
    }

    @Override
    @NotNull
    public B setDefaultColor(@NotNull String defaultColor) {
        this.defaultColor = defaultColor;
        return (B)this;
    }

    @Override
    @NotNull
    public String getFormat() {
        return this.format;
    }

    @Override
    @NotNull
    public B setFormat(@NotNull String format) {
        Preconditions.checkNotNull((Object)format, (Object)"Format cannot be null");
        this.format = format;
        return (B)this;
    }

    @Override
    @NotNull
    public Membership getMembership() {
        return this.membership;
    }

    @Override
    @NotNull
    public B setMembership(@NotNull Membership membership) {
        Preconditions.checkNotNull((Object)((Object)membership), (Object)"Membership cannot be null");
        this.membership = membership;
        return (B)this;
    }

    @Override
    public boolean isDoCooldown() {
        return this.doCooldown;
    }

    @Override
    @NotNull
    public B setDoCooldown(boolean doCooldown) {
        this.doCooldown = doCooldown;
        return (B)this;
    }

    @Override
    public boolean isDoProfanityFilter() {
        return this.doProfanityFilter;
    }

    @Override
    @NotNull
    public B setDoProfanityFilter(boolean doProfanityFilter) {
        this.doProfanityFilter = doProfanityFilter;
        return (B)this;
    }

    @Override
    public boolean isDoUrlFilter() {
        return this.doUrlFilter;
    }

    @Override
    @NotNull
    public B setDoUrlFilter(boolean doUrlFilter) {
        this.doUrlFilter = doUrlFilter;
        return (B)this;
    }

    @Override
    public boolean isCallEvent() {
        return this.callEvent;
    }

    @Override
    @NotNull
    public B setCallEvent(boolean callEvent) {
        this.callEvent = callEvent;
        return (B)this;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public B setPriority(@Range(from=-1L, to=0x7FFFFFFFL) int priority) {
        this.priority = priority;
        return (B)this;
    }

    @Override
    public String getBroadcastFormat() {
        return this.broadcastFormat != null ? this.broadcastFormat : "&8[&c" + this.getName() + "&8] &f{message}";
    }

    @Override
    @NotNull
    public B setBroadcastFormat(@NotNull String broadcastFormat) {
        this.broadcastFormat = broadcastFormat;
        return (B)this;
    }

    static boolean isLocal(@NotNull String identifier) {
        return identifier.equalsIgnoreCase("world") || identifier.equalsIgnoreCase("proximity") || identifier.equalsIgnoreCase("world_strict") || identifier.equalsIgnoreCase("proximity_strict");
    }
}

