/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.api.channel.data;

import com.pedestriamc.strings.api.StringsPlatform;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.channel.data.AbstractChannelBuilder;
import com.pedestriamc.strings.api.channel.data.ChannelBuilder;
import com.pedestriamc.strings.api.channel.data.IChannelBuilder;
import com.pedestriamc.strings.api.channel.data.LocalChannelBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class BuilderRegistry {
    private static StringsPlatform platform;
    private static final Map<String, BiFunction<StringsPlatform, ChannelBuilder, Channel>> BUILD_FUNCTIONS;
    private static final Map<String, BiFunction<StringsPlatform, LocalChannelBuilder<?>, Channel>> LOCAL_BUILD_FUNCTIONS;

    private BuilderRegistry() {
    }

    public static <B> Channel build(@NotNull IChannelBuilder<?> builder, @NotNull String type) throws IllegalArgumentException {
        if (AbstractChannelBuilder.isLocal(type)) {
            if (!(builder instanceof LocalChannelBuilder)) {
                throw new IllegalArgumentException("Local channels must be built with LocalChannelBuilder");
            }
            try {
                return LOCAL_BUILD_FUNCTIONS.get(type).apply(platform, (LocalChannelBuilder)builder);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (!BUILD_FUNCTIONS.containsKey(type)) {
            throw new IllegalArgumentException("Unknown channel type: " + type);
        }
        try {
            return BUILD_FUNCTIONS.get(type).apply(platform, (ChannelBuilder)builder);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static void registerBuildable(@NotNull String identifier, @NotNull BiFunction<StringsPlatform, ChannelBuilder, Channel> function) {
        BUILD_FUNCTIONS.put(identifier, function);
    }

    static void registerLocalBuildable(@NotNull String identifier, @NotNull BiFunction<StringsPlatform, LocalChannelBuilder<?>, Channel> function) {
        LOCAL_BUILD_FUNCTIONS.put(identifier, function);
    }

    static void registerPlatform(@NotNull StringsPlatform platform) {
        BuilderRegistry.platform = platform;
    }

    static {
        BUILD_FUNCTIONS = new HashMap<String, BiFunction<StringsPlatform, ChannelBuilder, Channel>>();
        LOCAL_BUILD_FUNCTIONS = new HashMap();
    }
}

