/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.api.channel.local;

import com.pedestriamc.strings.api.channel.local.LocalityImpl;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface Locality<T> {
    @NotNull
    public static <W> Locality<W> of(W w) {
        return new LocalityImpl<W>(w);
    }

    @NotNull
    public static <W> Set<Locality<W>> convertToLocalities(@NotNull Set<W> worlds) {
        HashSet<Locality<W>> result = new HashSet<Locality<W>>();
        for (W world : worlds) {
            result.add(Locality.of(world));
        }
        return result;
    }

    @NotNull
    public static <W> Set<W> convertToWorlds(@NotNull Set<Locality<W>> localities) {
        HashSet<W> result = new HashSet<W>();
        for (Locality<W> locality : localities) {
            result.add(locality.get());
        }
        return result;
    }

    @NotNull
    public T get();
}

