/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.api.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.collections4.iterators.ArrayIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoundedLinkedBuffer<T>
implements Collection<T> {
    private int size = 0;
    private final int capacity;
    private Node<T> head;
    private Node<T> tail;

    public BoundedLinkedBuffer(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public boolean add(T t) {
        if (this.head == null) {
            this.head = new Node<T>(t);
            this.tail = this.head;
            ++this.size;
            return true;
        }
        this.head.previous = new Node<T>(t, this.head);
        this.head = this.head.previous;
        if (this.size == this.capacity) {
            if (this.tail != null) {
                Node<T> previous = this.tail.previous();
                if (previous != null) {
                    previous.next = null;
                }
                this.tail = previous;
            }
        } else {
            ++this.size;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        for (Node<T> current = this.head; current != null; current = current.next()) {
            if (!Objects.equals(current.get(), o)) {
                continue;
            }
            Node<T> next = current.next();
            Node<T> previous = current.previous();
            if (previous == null) {
                this.head = next;
            } else {
                previous.next = next;
            }
            if (next == null) {
                this.tail = previous;
            } else {
                next.previous = previous;
            }
            --this.size;
            return true;
        }
        return false;
    }

    @Nullable
    public Node<T> getHead() {
        return this.head;
    }

    @Nullable
    public Node<T> getTail() {
        return this.tail;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (Node<T> current = this.head; current != null; current = current.next()) {
            T val = current.get();
            if (!Objects.equals(val, o)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new ArrayIterator(this.toArray());
    }

    @Override
    public Object @NotNull [] toArray() {
        Object[] array = new Object[this.size];
        int pos = 0;
        for (Node<T> current = this.head; current != null; current = current.next()) {
            array[pos++] = current.get();
        }
        return array;
    }

    @Override
    public <V> V @NotNull [] toArray(V @NotNull [] a) {
        return new Object[0];
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        boolean changed = false;
        for (T t : c) {
            if (!this.add(t)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        Object[] values;
        boolean changed = false;
        for (Object t : values = this.toArray()) {
            if (c.contains(t)) continue;
            this.remove(t);
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.head = null;
        this.tail = null;
    }

    public static final class Node<T> {
        private final T t;
        private Node<T> next;
        private Node<T> previous;

        Node(T t) {
            this(t, null, null);
        }

        Node(T t, Node<T> next) {
            this(t, next, null);
        }

        Node(T t, Node<T> next, Node<T> prev) {
            this.t = t;
            this.next = next;
            this.previous = prev;
        }

        @Nullable
        public Node<T> next() {
            return this.next;
        }

        @Nullable
        public Node<T> previous() {
            return this.previous;
        }

        @Nullable
        public T get() {
            return this.t;
        }
    }
}

