/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.api.event.channel;

import com.pedestriamc.strings.api.channel.Channel;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class ChannelChatEvent
extends AsyncPlayerChatEvent {
    private static final boolean IS_PAPER;
    private static final HandlerList HANDLERS;
    private final Channel channel;
    private final boolean cancellable;

    @ApiStatus.Internal
    public ChannelChatEvent(boolean async, @NotNull Player who, @NotNull String message, @NotNull Set<Player> players, Channel channel, boolean cancellable) {
        super(async, who, message, players);
        this.channel = channel;
        this.cancellable = cancellable;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public boolean cancellable() {
        return this.cancellable;
    }

    public boolean isCancelled() {
        return this.cancellable && super.isCancelled();
    }

    @NotNull
    public HandlerList getHandlers() {
        if (IS_PAPER) {
            return HANDLERS;
        }
        return super.getHandlers();
    }

    @NotNull
    public static HandlerList getHandlerList() {
        if (IS_PAPER) {
            return HANDLERS;
        }
        return AsyncPlayerChatEvent.getHandlerList();
    }

    static {
        boolean paperDetected = false;
        try {
            Class.forName("io.papermc.paper.event.player.AsyncChatEvent");
            paperDetected = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        IS_PAPER = paperDetected;
        HANDLERS = new HandlerList();
    }
}

