/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.api.message;

import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.message.Messageable;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MessageContext {
    private final Message message;
    private final Messageable recipient;
    private final Map<String, String> placeholders;
    private final boolean usePrefix;

    @NotNull
    public static MessageContext of(@NotNull Message message, @NotNull Map<String, String> placeholders, @NotNull Messageable recipient, boolean usePrefix) {
        return new MessageContext(message, placeholders, recipient, usePrefix);
    }

    @NotNull
    public static MessageContext of(Message message, Messageable recipient, boolean usePrefix) {
        return new MessageContext(message, null, recipient, usePrefix);
    }

    private MessageContext(Message message, Map<String, String> placeholders, Messageable recipient, boolean usePrefix) {
        this.message = message;
        this.recipient = recipient;
        this.placeholders = placeholders;
        this.usePrefix = usePrefix;
    }

    @NotNull
    @ApiStatus.Internal
    public Message message() {
        return this.message;
    }

    @NotNull
    @ApiStatus.Internal
    public Messageable recipient() {
        return this.recipient;
    }

    @Nullable
    @ApiStatus.Internal
    public Map<String, String> placeholders() {
        return this.placeholders;
    }

    @ApiStatus.Internal
    public boolean usePrefix() {
        return this.usePrefix;
    }
}

