/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.api.text.format;

import com.google.common.collect.ImmutableList;
import com.pedestriamc.strings.api.text.format.Element;
import com.pedestriamc.strings.api.text.format.StringsComponentUtils;
import com.pedestriamc.strings.api.text.format.StringsTextColor;
import com.pedestriamc.strings.api.text.format.StringsTextComponent;
import com.pedestriamc.strings.api.text.format.StringsTextDecoration;
import com.pedestriamc.strings.api.text.format.StringsTextReset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringsComponent
implements ComponentLike {
    private static final Set<StringsComponent> instances = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));
    private final List<Element<?>> elements;
    private final Component component;
    private final String toString;

    @Contract(value="_ -> new")
    @NotNull
    public static StringsComponent fromString(@NotNull String string) {
        return StringsComponentUtils.createFromString(string);
    }

    @NotNull
    public static StringsComponent of(Element<?> ... elements) {
        return StringsComponent.of(List.of(elements));
    }

    @NotNull
    public static StringsComponent of(@NotNull List<Element<?>> elements) {
        StringsComponent c = StringsComponent.resolveInstance(elements);
        if (c != null) {
            return c;
        }
        return new StringsComponent(elements);
    }

    private StringsComponent(List<Element<?>> elements) {
        this.elements = ImmutableList.copyOf(elements);
        StringsTextColor lastColor = StringsTextColor.WHITE;
        ArrayList<TextDecoration> lastDecorations = new ArrayList<TextDecoration>();
        Object temp = Component.text().build();
        TextComponent.Builder builder = Component.text();
        for (Element<?> element : elements) {
            if (element instanceof StringsTextColor) {
                StringsTextColor color = (StringsTextColor)element;
                temp = temp.append((Component)builder.build());
                builder = Component.text();
                builder.color(color);
                builder.decorate(lastDecorations.toArray(new TextDecoration[0]));
                lastColor = color;
                continue;
            }
            if (element instanceof StringsTextDecoration) {
                StringsTextDecoration decoration = (StringsTextDecoration)element;
                temp = temp.append((Component)builder.build());
                builder = Component.text();
                builder.decorate(decoration.toAdventure());
                builder.color(lastColor);
                lastDecorations.add(decoration.toAdventure());
                continue;
            }
            if (element instanceof StringsTextReset) {
                StringsTextReset reset = (StringsTextReset)element;
                temp = temp.append((Component)builder.build());
                lastDecorations.clear();
                lastColor = StringsTextColor.WHITE;
                builder = Component.text();
                builder.append(reset.asComponent());
                continue;
            }
            if (!(element instanceof StringsTextComponent)) continue;
            StringsTextComponent text = (StringsTextComponent)element;
            builder.append(text.asComponent());
        }
        this.component = temp = temp.append((Component)builder.build());
        instances.add(this);
        this.toString = StringsComponentUtils.convertToString(this);
    }

    @NotNull
    public StringsComponent append(Element<?> ... elements) {
        ArrayList newElements = new ArrayList(this.elements);
        newElements.addAll(List.of(elements));
        return StringsComponent.of(newElements);
    }

    @NotNull
    public StringsComponent append(@NotNull StringsComponent that) {
        ArrayList newElements = new ArrayList(this.elements);
        newElements.addAll(that.elements);
        return StringsComponent.of(newElements);
    }

    @NotNull
    public StringsComponent append(@NotNull String string) {
        ArrayList newElements = new ArrayList(this.elements);
        newElements.add(StringsTextComponent.of(string));
        return StringsComponent.of(newElements);
    }

    @Nullable
    private static StringsComponent resolveInstance(List<Element<?>> elements) {
        for (StringsComponent stringsComponent : instances) {
            if (stringsComponent == null || !stringsComponent.elements.equals(elements)) continue;
            return stringsComponent;
        }
        return null;
    }

    List<Element<?>> getElements() {
        return this.elements;
    }

    @Override
    @NotNull
    public Component asComponent() {
        return this.component;
    }

    @NotNull
    public String toString() {
        return this.toString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringsComponent that = (StringsComponent)o;
        return this.elements.equals(that.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }
}

