/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.api.text.format;

import com.pedestriamc.strings.api.text.format.Element;
import com.pedestriamc.strings.api.text.format.StringsComponent;
import com.pedestriamc.strings.api.text.format.StringsTextColor;
import com.pedestriamc.strings.api.text.format.StringsTextComponent;
import com.pedestriamc.strings.api.text.format.StringsTextDecoration;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class StringsComponentUtils {
    private static final Pattern STANDARD_CODE = Pattern.compile("\u00a7[0-9a-frk-o]", 2);

    private StringsComponentUtils() {
    }

    @Contract(pure=true)
    @NotNull
    static List<Element<?>> compact(@NotNull List<Element<?>> elements) {
        ArrayList compacted = new ArrayList();
        ListIterator<Element<?>> it = elements.listIterator();
        StringsTextComponent compact = StringsTextComponent.of();
        while (it.hasNext()) {
            Element<?> element = it.next();
            if (element instanceof StringsTextComponent) {
                StringsTextComponent c = (StringsTextComponent)element;
                compact = compact.append(c);
                continue;
            }
            if (!compact.isEmpty()) {
                compacted.add(compact);
                compact = StringsTextComponent.of();
            }
            compacted.add(element);
        }
        if (!compact.isEmpty()) {
            compacted.add(compact);
        }
        return compacted;
    }

    @NotNull
    static String convertToString(@NotNull StringsComponent component) {
        StringBuilder builder = new StringBuilder();
        for (Element<?> element : component.getElements()) {
            builder.append(element.toString());
        }
        return builder.toString();
    }

    @NotNull
    static StringsComponent createFromString(@NotNull String string) {
        ArrayList list = new ArrayList();
        Matcher hexMatcher = StringsTextColor.HEX_PATTERN.matcher(string);
        Matcher standardMatcher = STANDARD_CODE.matcher(string);
        int i = 0;
        while (i < string.length()) {
            String match;
            if (i + 14 <= string.length()) {
                hexMatcher.region(i, i + 14);
                if (hexMatcher.matches()) {
                    match = hexMatcher.group();
                    list.add(StringsTextColor.fromSectionHexString(match));
                    i += 14;
                    continue;
                }
            }
            if (i + 2 <= string.length()) {
                standardMatcher.region(i, i + 2);
                if (standardMatcher.matches()) {
                    match = standardMatcher.group();
                    Element<?> el = StringsComponentUtils.fromChar(match.charAt(1));
                    if (el != null) {
                        list.add(el);
                    }
                    i += 2;
                    continue;
                }
            }
            String at = String.valueOf(string.charAt(i));
            list.add(StringsTextComponent.of(at));
            ++i;
        }
        return StringsComponent.of(list);
    }

    @Nullable
    private static Element<?> fromChar(char ch) {
        Element<TextColor> el = StringsTextColor.fromChar(ch);
        if (el == null) {
            el = StringsTextDecoration.fromChar(ch);
        }
        return el;
    }
}

