/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.api.text.format;

import com.pedestriamc.strings.api.text.format.Element;
import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringsTextColor
implements Element<TextColor>,
TextColor,
Serializable {
    public static final StringsTextColor BLACK = new StringsTextColor(0);
    public static final StringsTextColor DARK_BLUE = new StringsTextColor(170);
    public static final StringsTextColor DARK_GREEN = new StringsTextColor(43520);
    public static final StringsTextColor DARK_AQUA = new StringsTextColor(43690);
    public static final StringsTextColor DARK_RED = new StringsTextColor(0xAA0000);
    public static final StringsTextColor DARK_PURPLE = new StringsTextColor(0xAA00AA);
    public static final StringsTextColor GOLD = new StringsTextColor(0xFFAA00);
    public static final StringsTextColor GRAY = new StringsTextColor(0xAAAAAA);
    public static final StringsTextColor DARK_GRAY = new StringsTextColor(0x555555);
    public static final StringsTextColor BLUE = new StringsTextColor(0x5555FF);
    public static final StringsTextColor GREEN = new StringsTextColor(0x55FF55);
    public static final StringsTextColor AQUA = new StringsTextColor(0x55FFFF);
    public static final StringsTextColor RED = new StringsTextColor(0xFF5555);
    public static final StringsTextColor PINK = new StringsTextColor(0xFF55FF);
    public static final StringsTextColor YELLOW = new StringsTextColor(0xFFFF55);
    public static final StringsTextColor WHITE = new StringsTextColor(0xFFFFFF);
    private static final Map<Character, StringsTextColor> legacyCodes = new HashMap<Character, StringsTextColor>();
    public static final Pattern HEX_PATTERN;
    private final int value;

    @ApiStatus.Internal
    private StringsTextColor(@NotNull net.md_5.bungee.api.ChatColor chatColor) {
        this.value = chatColor.getColor().getRGB() & 0xFFFFFF;
    }

    @ApiStatus.Internal
    private StringsTextColor(@NotNull ChatColor chatColor) {
        this(chatColor.asBungee());
    }

    @ApiStatus.Internal
    private StringsTextColor(int value) {
        this.value = value & 0xFFFFFF;
    }

    @NotNull
    public static StringsTextColor of(@NotNull net.md_5.bungee.api.ChatColor color) {
        return new StringsTextColor(color);
    }

    @NotNull
    public static StringsTextColor of(@NotNull ChatColor color) {
        return new StringsTextColor(color);
    }

    @NotNull
    public static StringsTextColor of(@NotNull Color color) {
        return new StringsTextColor(net.md_5.bungee.api.ChatColor.of((Color)color));
    }

    @NotNull
    public static StringsTextColor of(@NotNull String string) {
        return new StringsTextColor(net.md_5.bungee.api.ChatColor.of((String)string));
    }

    @Nullable
    public static StringsTextColor fromChar(char legacyChar) {
        return legacyCodes.get(Character.valueOf(legacyChar));
    }

    @NotNull
    public static StringsTextColor fromSectionHexString(@NotNull String hexString) {
        if (!HEX_PATTERN.matcher(hexString).matches()) {
            throw new IllegalArgumentException("Invalid hex string: " + hexString);
        }
        StringBuilder hex = StringsTextColor.generateBuilder(hexString);
        if (hex.length() != 7) {
            throw new IllegalArgumentException("Final hex must be 6 digits long: " + String.valueOf(hex));
        }
        return StringsTextColor.of(hex.toString().toUpperCase(Locale.ROOT));
    }

    @NotNull
    private static StringBuilder generateBuilder(@NotNull String hexString) {
        StringBuilder hex = new StringBuilder(7);
        hex.append('#');
        for (int i = 2; i < hexString.length(); i += 2) {
            if (hexString.charAt(i) != '\u00a7') {
                throw new IllegalArgumentException("Expected '\u00a7' at position " + i + " in " + hexString);
            }
            char c = hexString.charAt(i + 1);
            if (!StringsTextColor.isHexChar(c)) {
                throw new IllegalArgumentException("Invalid hex digit: '" + c + "' in " + hexString);
            }
            hex.append(c);
        }
        return hex;
    }

    private static boolean isHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    @NotNull
    public static net.md_5.bungee.api.ChatColor asChatColor(@NotNull TextColor textColor) {
        return net.md_5.bungee.api.ChatColor.of((Color)new Color(textColor.red(), textColor.green(), textColor.blue()));
    }

    @NotNull
    public net.md_5.bungee.api.ChatColor chatColor() {
        return StringsTextColor.asChatColor(this);
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    @NotNull
    public String toString() {
        return this.chatColor().toString();
    }

    @Override
    @NotNull
    public TextColor toAdventure() {
        return this;
    }

    @Override
    @NotNull
    public Element.Type getType() {
        return Element.Type.COLOR;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StringsTextColor that = (StringsTextColor)object;
        return this.value == that.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    @NotNull
    public Component asComponent() {
        return ((TextComponent.Builder)Component.text().color(this)).build();
    }

    static {
        legacyCodes.put(Character.valueOf('0'), BLACK);
        legacyCodes.put(Character.valueOf('1'), DARK_BLUE);
        legacyCodes.put(Character.valueOf('2'), DARK_GREEN);
        legacyCodes.put(Character.valueOf('3'), DARK_AQUA);
        legacyCodes.put(Character.valueOf('4'), DARK_RED);
        legacyCodes.put(Character.valueOf('5'), DARK_PURPLE);
        legacyCodes.put(Character.valueOf('6'), GOLD);
        legacyCodes.put(Character.valueOf('7'), GRAY);
        legacyCodes.put(Character.valueOf('8'), DARK_GRAY);
        legacyCodes.put(Character.valueOf('9'), BLUE);
        legacyCodes.put(Character.valueOf('a'), GREEN);
        legacyCodes.put(Character.valueOf('b'), AQUA);
        legacyCodes.put(Character.valueOf('c'), RED);
        legacyCodes.put(Character.valueOf('d'), PINK);
        legacyCodes.put(Character.valueOf('e'), YELLOW);
        legacyCodes.put(Character.valueOf('f'), WHITE);
        HEX_PATTERN = Pattern.compile("\\u00A7x(\\u00A7[0-9a-fA-F]){6}");
    }
}

