/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.api.text.format;

import com.pedestriamc.strings.api.text.format.Element;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class StringsTextComponent
implements TextComponent,
Element<TextComponent> {
    @NotNull
    private final String content;

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static StringsTextComponent of(@NotNull String content) {
        return new StringsTextComponent(content);
    }

    @NotNull
    public static StringsTextComponent of() {
        return new StringsTextComponent("");
    }

    private StringsTextComponent(@NotNull String content) {
        this.content = content;
    }

    @Override
    @NotNull
    public String content() {
        return this.content;
    }

    @Override
    @NotNull
    public TextComponent content(@NotNull String content) {
        return StringsTextComponent.of(content);
    }

    public StringsTextComponent append(@NotNull String content) {
        return StringsTextComponent.of(this.content + content);
    }

    public StringsTextComponent append(@NotNull StringsTextComponent content) {
        return StringsTextComponent.of(this.content + content.content);
    }

    @Override
    @NotNull
    public TextComponent.Builder toBuilder() {
        return Component.text().content(this.content());
    }

    @Override
    @NotNull
    public @Unmodifiable List<Component> children() {
        return List.of();
    }

    @Override
    @NotNull
    public TextComponent children(@NotNull List<? extends ComponentLike> children) {
        return this;
    }

    @Override
    @NotNull
    public Style style() {
        return Style.empty();
    }

    @Override
    @NotNull
    public TextComponent style(@NotNull Style style) {
        return (TextComponent)Component.text(this.content()).style(style);
    }

    @Override
    @NotNull
    public TextComponent toAdventure() {
        return this;
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    @NotNull
    public Element.Type getType() {
        return Element.Type.TEXT;
    }

    @Override
    @NotNull
    public String toString() {
        return this.content();
    }
}

