/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.api.text.format;

import com.pedestriamc.strings.api.text.format.Element;
import com.pedestriamc.strings.api.text.format.StringsTextReset;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum StringsTextDecoration implements Element<TextDecoration>
{
    BOLD(TextDecoration.BOLD, net.md_5.bungee.api.ChatColor.BOLD),
    ITALIC(TextDecoration.ITALIC, net.md_5.bungee.api.ChatColor.ITALIC),
    UNDERLINE(TextDecoration.UNDERLINED, net.md_5.bungee.api.ChatColor.UNDERLINE),
    STRIKETHROUGH(TextDecoration.STRIKETHROUGH, net.md_5.bungee.api.ChatColor.STRIKETHROUGH),
    MAGIC(TextDecoration.OBFUSCATED, net.md_5.bungee.api.ChatColor.MAGIC);

    public static final Element<Component> RESET;
    private static final BidiMap<TextDecoration, net.md_5.bungee.api.ChatColor> mappings;
    private static final Map<Character, Element<?>> legacyCodes;
    private final TextDecoration decoration;
    private final net.md_5.bungee.api.ChatColor chatColor;
    private final Component component;

    public static Element<?> fromChar(char legacyChar) {
        return legacyCodes.get(Character.valueOf(legacyChar));
    }

    @Nullable
    private static TextDecoration to(@NotNull net.md_5.bungee.api.ChatColor color) {
        return mappings.getKey(color);
    }

    @Nullable
    private static net.md_5.bungee.api.ChatColor to(@NotNull TextDecoration decoration) {
        return (net.md_5.bungee.api.ChatColor)mappings.get(decoration);
    }

    @Nullable
    private static TextDecoration to(@NotNull ChatColor color) {
        return mappings.getKey(color.asBungee());
    }

    private StringsTextDecoration(TextDecoration decoration, net.md_5.bungee.api.ChatColor chatColor) {
        this.decoration = decoration;
        this.chatColor = chatColor;
        this.component = ((TextComponent.Builder)Component.text().decorate(this.toAdventure())).build();
    }

    @NotNull
    public net.md_5.bungee.api.ChatColor chatColor() {
        return this.chatColor;
    }

    @Override
    @NotNull
    public String toString() {
        return this.chatColor.toString();
    }

    @Override
    @NotNull
    public TextDecoration toAdventure() {
        return this.decoration;
    }

    @Override
    @NotNull
    public Element.Type getType() {
        return Element.Type.DECORATION;
    }

    @Override
    @NotNull
    public Component asComponent() {
        return this.component;
    }

    static {
        RESET = StringsTextReset.INSTANCE;
        mappings = new DualHashBidiMap<TextDecoration, net.md_5.bungee.api.ChatColor>();
        mappings.put(TextDecoration.BOLD, net.md_5.bungee.api.ChatColor.BOLD);
        mappings.put(TextDecoration.ITALIC, net.md_5.bungee.api.ChatColor.ITALIC);
        mappings.put(TextDecoration.UNDERLINED, net.md_5.bungee.api.ChatColor.UNDERLINE);
        mappings.put(TextDecoration.STRIKETHROUGH, net.md_5.bungee.api.ChatColor.STRIKETHROUGH);
        mappings.put(TextDecoration.OBFUSCATED, net.md_5.bungee.api.ChatColor.MAGIC);
        legacyCodes = new HashMap();
        legacyCodes.put(Character.valueOf('k'), MAGIC);
        legacyCodes.put(Character.valueOf('l'), BOLD);
        legacyCodes.put(Character.valueOf('m'), STRIKETHROUGH);
        legacyCodes.put(Character.valueOf('o'), ITALIC);
        legacyCodes.put(Character.valueOf('n'), UNDERLINE);
        legacyCodes.put(Character.valueOf('r'), RESET);
    }
}

