/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.channel;

import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.channel.Type;
import com.pedestriamc.strings.api.channel.local.LocalChannel;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.channel.base.ProtectedChannel;
import com.pedestriamc.strings.chat.ChannelManager;
import com.pedestriamc.strings.user.User;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.bukkit.ChatColor;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public final class DefaultChannel
extends ProtectedChannel {
    private final ChannelManager channelManager;
    private final Set<StringsUser> members;

    public DefaultChannel(@NotNull ChannelManager channelManager) {
        super("default");
        this.channelManager = channelManager;
        this.members = new HashSet<StringsUser>();
    }

    @Override
    public void sendMessage(@NotNull StringsUser user, @NotNull String message) {
        Channel channel = this.resolve(user);
        if (!channel.equals(this)) {
            channel.sendMessage(user, message);
            return;
        }
        user.sendMessage(String.valueOf(ChatColor.RED) + "[Strings] You aren't a member of any channels.  Please contact a server operator for help.");
    }

    @Override
    @NotNull
    public Channel resolve(@NotNull StringsUser player) {
        SortedSet<Channel> channels = this.channelManager.getSortedChannelSet();
        channels.removeIf(channel -> !channel.allows((Permissible)User.playerOf(player)));
        channels.removeIf(channel -> {
            LocalChannel local;
            return channel instanceof LocalChannel && !(local = (LocalChannel)channel).containsInScope(player);
        });
        channels.removeIf(player::hasChannelMuted);
        if (!channels.isEmpty()) {
            return channels.first();
        }
        TreeSet<Channel> usersChannels = new TreeSet<Channel>(player.getChannels());
        usersChannels.remove(this);
        if (!usersChannels.isEmpty()) {
            return (Channel)usersChannels.first();
        }
        return this;
    }

    @Override
    @NotNull
    public Type getType() {
        return Type.DEFAULT;
    }

    @Override
    public boolean allows(@NotNull Permissible permissible) {
        return true;
    }

    @Override
    public void setName(@NotNull String name) {
    }

    @Override
    public void addMember(@NotNull StringsUser user) {
        this.members.add(user);
    }

    @Override
    public void removeMember(@NotNull StringsUser user) {
        this.members.remove(user);
    }

    @Override
    public Set<StringsUser> getMembers() {
        return new HashSet<StringsUser>(this.members);
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "defaultchannel";
    }
}

