/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.channel;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.StringsPlatform;
import com.pedestriamc.strings.api.channel.data.IChannelBuilder;
import com.pedestriamc.strings.api.event.channel.ChannelChatEvent;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.text.format.StringsTextColor;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.channel.base.ProtectedChannel;
import com.pedestriamc.strings.chat.MessageProcessor;
import com.pedestriamc.strings.impl.BukkitMessenger;
import com.pedestriamc.strings.user.User;
import java.util.HashSet;
import java.util.Set;
import me.clip.placeholderapi.PlaceholderAPI;
import net.wiicart.commands.permission.Permissions;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class HelpOPChannel
extends ProtectedChannel {
    public static final String IDENTIFIER = "helpop";
    private final Strings strings;
    private final MessageProcessor messageProcessor;
    private final boolean callEvent;
    private String format;
    private boolean urlFilter;
    private boolean profanityFilter;
    private final BukkitMessenger messenger;
    private final boolean usePAPI;

    public HelpOPChannel(@NotNull Strings strings, String format, boolean callEvent, boolean urlFilter, boolean profanityFilter) {
        super(IDENTIFIER);
        this.strings = strings;
        this.callEvent = callEvent;
        this.format = format;
        this.urlFilter = urlFilter;
        this.profanityFilter = profanityFilter;
        this.messenger = strings.getMessenger();
        this.usePAPI = strings.isUsingPlaceholderAPI();
        this.messageProcessor = new MessageProcessor(strings, this);
    }

    public HelpOPChannel(@NotNull StringsPlatform plugin, @NotNull IChannelBuilder<?> builder) {
        this((Strings)plugin, builder);
    }

    public HelpOPChannel(@NotNull Strings strings, @NotNull IChannelBuilder<?> data) {
        super(IDENTIFIER);
        this.strings = strings;
        this.messenger = strings.getMessenger();
        this.callEvent = data.isCallEvent();
        this.format = data.getFormat();
        this.urlFilter = data.isDoUrlFilter();
        this.profanityFilter = data.isDoProfanityFilter();
        this.usePAPI = strings.isUsingPlaceholderAPI();
        this.messageProcessor = new MessageProcessor(strings, this);
    }

    @Override
    public void sendMessage(@NotNull StringsUser user, @NotNull String message) {
        Set<Player> members = this.getRecipients();
        Player player = User.playerOf(user);
        String messageFormat = this.generateTemplate(player);
        String finalMessage = message = this.messageProcessor.processMessage(player, message);
        String formattedMessage = messageFormat.replace("{message}", finalMessage);
        if (this.callEvent) {
            Bukkit.getScheduler().runTask((Plugin)this.strings, () -> {
                ChannelChatEvent event = new ChannelChatEvent(false, player, finalMessage, members, this, true);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    for (Player p : members) {
                        p.sendMessage(formattedMessage);
                    }
                    Bukkit.getLogger().info(net.md_5.bungee.api.ChatColor.stripColor((String)formattedMessage));
                }
            });
        } else {
            for (Player p : members) {
                p.sendMessage(formattedMessage);
            }
            Bukkit.getLogger().info(net.md_5.bungee.api.ChatColor.stripColor((String)formattedMessage));
        }
        this.messenger.sendMessage(Message.HELPOP_SENT, (CommandSender)player);
    }

    private Set<Player> getRecipients() {
        HashSet<Player> members = new HashSet<Player>();
        for (OfflinePlayer op : Bukkit.getOperators()) {
            Player p;
            if (op.getName() == null || (p = Bukkit.getPlayer((String)op.getName())) == null) continue;
            members.add(p);
        }
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (!Permissions.anyOfOrAdmin((Permissible)onlinePlayer, "strings.helpop.receive", "strings.helpop.*", "strings.*")) continue;
            members.add(onlinePlayer);
        }
        return members;
    }

    private String generateTemplate(Player player) {
        User user = this.strings.users().getUser(player);
        String template = this.getFormat();
        template = template.replace("{prefix}", user.getPrefix()).replace("{suffix}", user.getSuffix()).replace("{displayname}", user.getDisplayName()).replace("{message}", user.getChatColor(this) + "{message}");
        if (this.usePAPI) {
            template = PlaceholderAPI.setPlaceholders((Player)player, (String)template);
        }
        template = ChatColor.translateAlternateColorCodes((char)'&', (String)template);
        return template;
    }

    @Override
    public String getDefaultColor() {
        return StringsTextColor.RED.toString();
    }

    @Override
    public boolean callsEvents() {
        return this.callEvent;
    }

    @Override
    @NotNull
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(@NotNull String format) {
        this.format = format;
    }

    @Override
    public boolean isUrlFiltering() {
        return this.urlFilter;
    }

    @Override
    public void setUrlFilter(boolean urlFilter) {
        this.urlFilter = urlFilter;
    }

    @Override
    public boolean isProfanityFiltering() {
        return this.profanityFilter;
    }

    @Override
    public void setProfanityFilter(boolean profanityFilter) {
        this.profanityFilter = profanityFilter;
    }

    @Override
    public boolean allows(@NotNull Permissible permissible) {
        return Permissions.anyOfOrAdmin(permissible, "strings.*", "strings.helpop.use");
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return IDENTIFIER;
    }
}

