/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.channel;

import com.pedestriamc.strings.api.text.format.StringsTextColor;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.channel.base.ProtectedChannel;
import com.pedestriamc.strings.directmessage.PlayerDirectMessenger;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SocialSpyChannel
extends ProtectedChannel {
    private String format;
    private final PlayerDirectMessenger playerDirectMessenger;
    private final HashSet<StringsUser> spiesList;

    public SocialSpyChannel(PlayerDirectMessenger messenger, String format) {
        super("socialspy");
        this.format = format;
        this.playerDirectMessenger = messenger;
        this.spiesList = new HashSet();
    }

    public void sendOutMessage(Player sender, Player recipient, String message) {
        String msg = this.format;
        msg = this.playerDirectMessenger.processPlaceholders(sender, recipient, msg);
        msg = msg.replace("{message}", message);
        msg = ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
        for (StringsUser spy : this.spiesList) {
            spy.sendMessage(msg);
        }
    }

    @Override
    public void sendMessage(@NotNull StringsUser user, @NotNull String message) {
        for (StringsUser p : this.spiesList) {
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }

    @Override
    public void broadcast(@NotNull String message) {
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        this.broadcastPlain(message);
    }

    @Override
    public void broadcastPlain(@NotNull String message) {
        for (StringsUser p : this.spiesList) {
            p.sendMessage(message);
        }
    }

    @Override
    @NotNull
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(@NotNull String format) {
        this.format = format;
    }

    @Override
    public String getDefaultColor() {
        return StringsTextColor.WHITE.toString();
    }

    @Override
    public void addMember(@NotNull StringsUser player) {
        this.spiesList.add(player);
    }

    @Override
    public void removeMember(@NotNull StringsUser player) {
        this.spiesList.remove(player);
    }

    @Override
    public Set<StringsUser> getMembers() {
        return this.spiesList;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "socialspychannel";
    }
}

