/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.channel;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.StringsPlatform;
import com.pedestriamc.strings.api.channel.Membership;
import com.pedestriamc.strings.api.channel.Type;
import com.pedestriamc.strings.api.channel.data.IChannelBuilder;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.channel.base.AbstractChannel;
import com.pedestriamc.strings.user.util.UserUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public final class StringChannel
extends AbstractChannel {
    public static final String IDENTIFIER = "stringchannel";

    public StringChannel(StringsPlatform plugin, IChannelBuilder<?> builder) {
        this((Strings)plugin, builder);
    }

    public StringChannel(@NotNull Strings strings, @NotNull IChannelBuilder<?> builder) {
        super(strings, builder);
    }

    @Override
    @NotNull
    public Set<StringsUser> getRecipients(@NotNull StringsUser sender) {
        HashSet<StringsUser> recipients = new HashSet<StringsUser>(this.getMembers());
        UserUtil userUtil = this.getUserUtil();
        recipients.addAll(this.getMonitors());
        if (this.getMembership() == Membership.DEFAULT) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                recipients.add(userUtil.getUser(p));
                if (!p.hasPermission("strings.channels." + this.getName() + ".receive")) continue;
                recipients.add(userUtil.getUser(p));
            }
        }
        return this.filterMutesAndIgnores(sender, recipients);
    }

    @Override
    @NotNull
    public Set<StringsUser> getPlayersInScope() {
        return switch (this.getMembership()) {
            default -> throw new MatchException(null, null);
            case Membership.DEFAULT -> Bukkit.getOnlinePlayers().stream().map(this.getUserUtil()::getUser).collect(Collectors.toSet());
            case Membership.PROTECTED -> this.getMembers();
            case Membership.PERMISSION -> {
                HashSet<StringsUser> scoped = new HashSet<StringsUser>(this.getMembers());
                scoped.addAll(this.getMonitors());
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (!this.allows((Permissible)p)) continue;
                    scoped.add(this.getUserUtil().getUser(p));
                }
                yield scoped;
            }
        };
    }

    @Override
    @NotNull
    public Type getType() {
        return Type.NORMAL;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return IDENTIFIER;
    }
}

