/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.channel.base;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.channel.Membership;
import com.pedestriamc.strings.api.channel.Monitorable;
import com.pedestriamc.strings.api.channel.data.IChannelBuilder;
import com.pedestriamc.strings.api.event.channel.ChannelChatEvent;
import com.pedestriamc.strings.api.settings.Option;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.chat.Mentioner;
import com.pedestriamc.strings.chat.MessageProcessor;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.wiicart.commands.permission.Permissions;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractChannel
implements Channel,
Monitorable {
    private final Strings strings;
    private final MessageProcessor messageProcessor;
    private final UserUtil userUtil;
    private String name;
    private String defaultColor;
    private String format;
    private final String broadcastFormat;
    private final Membership membership;
    private boolean doCooldown;
    private boolean doProfanityFilter;
    private boolean doUrlFilter;
    private final boolean callEvent;
    private final boolean mentionsEnabled;
    private final int priority;
    private final Set<StringsUser> monitors;
    private final Set<StringsUser> members;
    protected static final String CHANNEL_PERMISSION = "strings.channels.";
    protected static final String MESSAGE_PLACEHOLDER = "{message}";
    protected static final String DEFAULT_BROADCAST_FORMAT = "&8[&3Broadcast&8] &f{message}";

    protected AbstractChannel(@NotNull Strings strings, @NotNull IChannelBuilder<?> data) {
        this.strings = strings;
        this.userUtil = strings.users();
        this.name = data.getName();
        this.defaultColor = data.getDefaultColor();
        this.format = data.getFormat();
        this.broadcastFormat = data.getBroadcastFormat();
        this.membership = data.getMembership();
        this.doCooldown = data.isDoCooldown();
        this.doProfanityFilter = data.isDoProfanityFilter();
        this.doUrlFilter = data.isDoUrlFilter();
        this.callEvent = data.isCallEvent();
        this.priority = data.getPriority();
        this.messageProcessor = new MessageProcessor(strings, this);
        this.mentionsEnabled = strings.getConfiguration().getBoolean(Option.Bool.ENABLE_MENTIONS);
        this.updatePermissions();
        this.members = new HashSet<StringsUser>();
        this.monitors = new HashSet<StringsUser>();
    }

    @Override
    public void sendMessage(@NotNull StringsUser user, @NotNull String message) {
        Player p = User.playerOf(user);
        Set<Player> recipients = this.convertToPlayers(this.getRecipients(user));
        String template = this.messageProcessor.generateTemplate(p);
        String processedMessage = this.messageProcessor.processMessage(p, message);
        if (this.mentionsEnabled && Mentioner.hasMentionPermission(p)) {
            processedMessage = this.messageProcessor.processMentions(p, processedMessage);
        }
        if (this.callsEvents()) {
            this.sendEventMessage(p, processedMessage, template, recipients);
        } else {
            this.sendNonEventMessage(p, message, template, recipients);
        }
    }

    private void sendEventMessage(@NotNull Player player, @NotNull String message, @NotNull String template, @NotNull Set<Player> recipients) {
        Bukkit.getScheduler().runTask((Plugin)this.strings, () -> {
            ChannelChatEvent event = new ChannelChatEvent(false, player, message, recipients, this, true);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                String finalForm = template.replace(MESSAGE_PLACEHOLDER, event.getMessage());
                for (Player p : recipients) {
                    p.sendMessage(finalForm);
                }
                Bukkit.getLogger().info(ChatColor.stripColor((String)finalForm));
                if (!recipients.contains(player)) {
                    player.sendMessage(finalForm);
                }
            }
        });
    }

    private void sendNonEventMessage(@NotNull Player player, @NotNull String message, @NotNull String template, @NotNull Set<Player> recipients) {
        String finalFormNonEvent = template.replace(MESSAGE_PLACEHOLDER, message);
        for (Player p : recipients) {
            p.sendMessage(finalFormNonEvent);
        }
        if (!recipients.contains(player)) {
            player.sendMessage(finalFormNonEvent);
        }
        Bukkit.getLogger().info(ChatColor.stripColor((String)finalFormNonEvent));
    }

    @NotNull
    private Set<Player> convertToPlayers(@NotNull Set<StringsUser> users) {
        HashSet<Player> recipients = new HashSet<Player>();
        for (StringsUser user : users) {
            try {
                recipients.add(User.playerOf(user));
            }
            catch (Exception exception) {}
        }
        return recipients;
    }

    private void updatePermissions() {
        Permissions util = new Permissions(this.strings);
        String permission = CHANNEL_PERMISSION + this.getName();
        try {
            util.addPermission(permission);
            util.addPermission(permission + ".broadcast");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Map<String, Object> getData() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("format", this.getFormat());
        map.put("default-color", this.getDefaultColor());
        map.put("call-event", String.valueOf(this.callsEvents()));
        map.put("filter-profanity", String.valueOf(this.isProfanityFiltering()));
        map.put("block-urls", String.valueOf(this.isUrlFiltering()));
        map.put("cooldown", String.valueOf(this.isCooldownEnabled()));
        map.put("type", String.valueOf((Object)this.getType()));
        map.put("membership", String.valueOf((Object)this.getMembership()));
        map.put("priority", String.valueOf(this.getPriority()));
        return map;
    }

    @NotNull
    protected Set<StringsUser> filterMutes(@NotNull Set<StringsUser> players) {
        return players.stream().filter(p -> {
            User user = this.userUtil.getUser(p.getUniqueId());
            return !user.hasChannelMuted(this);
        }).collect(Collectors.toSet());
    }

    protected Set<StringsUser> filterIgnores(@NotNull StringsUser sender, @NotNull Set<StringsUser> players) {
        return players.stream().filter(p -> {
            User user = this.userUtil.getUser(p.getUniqueId());
            return !user.isIgnoring(sender);
        }).collect(Collectors.toSet());
    }

    protected Set<StringsUser> filterMutesAndIgnores(@NotNull StringsUser sender, @NotNull Set<StringsUser> players) {
        players = this.filterIgnores(sender, players);
        players = this.filterMutes(players);
        return players;
    }

    protected UserUtil getUserUtil() {
        return this.userUtil;
    }

    @Override
    public boolean allows(@NotNull Permissible permissible) {
        if (permissible instanceof Player) {
            Player player = (Player)permissible;
            if (this.getMembers().contains(this.strings.users().getUser(player))) {
                return true;
            }
        }
        return Permissions.anyOfOrAdmin(permissible, CHANNEL_PERMISSION + this.getName(), "strings.channels.*", "strings.*");
    }

    @Override
    @NotNull
    public String getBroadcastFormat() {
        return Objects.requireNonNullElse(this.broadcastFormat, DEFAULT_BROADCAST_FORMAT);
    }

    @Override
    public void broadcast(@NotNull String message) {
        String finalString = this.getBroadcastFormat().replace(MESSAGE_PLACEHOLDER, message);
        finalString = ChatColor.translateAlternateColorCodes((char)'&', (String)finalString);
        this.broadcastPlain(finalString);
    }

    @Override
    public void broadcastPlain(@NotNull String message) {
        for (StringsUser user : this.getPlayersInScope()) {
            user.sendMessage(message);
        }
    }

    @Override
    public String getDefaultColor() {
        return this.defaultColor;
    }

    @Override
    public void setDefaultColor(String defaultColor) {
        this.defaultColor = defaultColor;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NotNull String name) {
        Permissions util = new Permissions(this.strings);
        String permission = CHANNEL_PERMISSION + this.getName();
        util.removePermission(permission);
        util.removePermission(permission + ".broadcast");
        this.name = name;
        this.updatePermissions();
    }

    @Override
    public boolean callsEvents() {
        return this.callEvent;
    }

    @Override
    public void addMember(@NotNull StringsUser user) {
        this.members.add(user);
    }

    @Override
    public void removeMember(@NotNull StringsUser user) {
        this.members.remove(user);
    }

    @Override
    public Set<StringsUser> getMembers() {
        return new HashSet<StringsUser>(this.members);
    }

    @Override
    public void addMonitor(@NotNull StringsUser user) {
        this.monitors.add(user);
    }

    @Override
    public void removeMonitor(@NotNull StringsUser user) {
        this.monitors.remove(user);
    }

    @Override
    @NotNull
    public Set<StringsUser> getMonitors() {
        return new HashSet<StringsUser>(this.monitors);
    }

    @Override
    public boolean isUrlFiltering() {
        return this.doUrlFilter;
    }

    @Override
    public void setUrlFilter(boolean doUrlFilter) {
        this.doUrlFilter = doUrlFilter;
    }

    @Override
    public boolean isProfanityFiltering() {
        return this.doProfanityFilter;
    }

    @Override
    public void setProfanityFilter(boolean doProfanityFilter) {
        this.doProfanityFilter = doProfanityFilter;
    }

    @Override
    public boolean isCooldownEnabled() {
        return this.doCooldown;
    }

    @Override
    public void setDoCooldown(boolean doCooldown) {
        this.doCooldown = doCooldown;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setFormat(@NotNull String format) {
        Objects.requireNonNull(format);
        this.format = format;
    }

    @Override
    @NotNull
    public String getFormat() {
        return this.format;
    }

    @Override
    public Membership getMembership() {
        return this.membership;
    }

    @Override
    @NotNull
    public Channel resolve(@NotNull StringsUser user) {
        return this;
    }

    @Override
    public int compareTo(@NotNull Channel o) {
        return Integer.compare(o.getPriority(), this.getPriority());
    }
}

