/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.channel.local;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Membership;
import com.pedestriamc.strings.api.channel.data.LocalChannelBuilder;
import com.pedestriamc.strings.api.channel.local.LocalChannel;
import com.pedestriamc.strings.api.channel.local.Locality;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.channel.base.AbstractChannel;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

abstract class AbstractLocalChannel
extends AbstractChannel
implements LocalChannel<World> {
    private final UserUtil userUtil = this.getUserUtil();
    private final Set<Locality<World>> worlds;

    protected AbstractLocalChannel(@NotNull Strings strings, @NotNull LocalChannelBuilder<?> data) {
        super(strings, data);
        try {
            LocalChannelBuilder<?> builder = data;
            this.worlds = new HashSet(builder.getWorlds());
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Invalid World implementation", e);
        }
        if (this.worlds.isEmpty()) {
            throw new IllegalArgumentException("Worlds cannot be empty");
        }
    }

    @Override
    public boolean containsInScope(@NotNull StringsUser user) {
        return this.containsWorld(User.of(user).getWorld());
    }

    @Override
    public Set<Locality<World>> getWorlds() {
        return new HashSet<Locality<World>>(this.worlds);
    }

    @Override
    public void setWorlds(@NotNull Set<Locality<World>> worlds) {
        this.worlds.clear();
        this.worlds.addAll(worlds);
    }

    @Override
    public boolean allows(@NotNull Permissible permissible) {
        if (permissible instanceof Player) {
            Player player = (Player)permissible;
            if (this.getMembership() == Membership.DEFAULT && this.containsWorld(player.getWorld())) {
                return true;
            }
        }
        return super.allows(permissible);
    }

    @Override
    public Map<String, Object> getData() {
        Map<String, Object> map = super.getData();
        map.put("worlds", this.getWorldNames());
        return map;
    }

    @Override
    @NotNull
    public Set<StringsUser> getPlayersInScope() {
        return switch (this.getMembership()) {
            case Membership.DEFAULT -> this.universalSet();
            case Membership.PERMISSION -> {
                HashSet<StringsUser> scoped = new HashSet<StringsUser>(this.universalSet());
                scoped.removeIf(p -> !this.allows((Permissible)User.playerOf(p)));
                yield scoped;
            }
            default -> {
                HashSet<StringsUser> scoped = new HashSet<StringsUser>(this.getMembers());
                scoped.addAll(this.getMonitors());
                yield scoped;
            }
        };
    }

    @Override
    public boolean containsWorld(@NotNull World world) {
        for (Locality<World> locality : this.worlds) {
            if (!locality.get().equals((Object)world)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getWorldNames() {
        ArrayList<String> worldNames = new ArrayList<String>();
        for (Locality<World> w : this.getWorlds()) {
            worldNames.add(w.get().getName());
        }
        return worldNames;
    }

    @NotNull
    protected Set<User> convertToUsers(@NotNull Collection<Player> players) {
        return players.stream().map(this.userUtil::getUser).collect(Collectors.toSet());
    }

    protected Set<StringsUser> universalSet() {
        HashSet<StringsUser> set = new HashSet<StringsUser>(this.getMembers());
        set.addAll(this.getMonitors());
        for (Locality<World> w : this.worlds) {
            set.addAll(w.get().getPlayers().stream().map(this.getUserUtil()::getUser).collect(Collectors.toSet()));
        }
        return set;
    }
}

