/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.channel.local;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.StringsPlatform;
import com.pedestriamc.strings.api.channel.Type;
import com.pedestriamc.strings.api.channel.data.LocalChannelBuilder;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.channel.local.AbstractLocalChannel;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class ProximityChannel
extends AbstractLocalChannel {
    public static final String IDENTIFIER = "proximity";
    private @Range(from=-1L, to=0x7FFFFFFFL) double distance;
    private double distanceSquared;

    public ProximityChannel(StringsPlatform plugin, LocalChannelBuilder<?> builder) {
        this((Strings)plugin, builder);
    }

    ProximityChannel(@NotNull Strings strings, @NotNull LocalChannelBuilder<?> builder) {
        super(strings, builder);
        this.distance = builder.getDistance();
        this.distanceSquared = this.distance * this.distance;
    }

    @Override
    @NotNull
    public Set<StringsUser> getRecipients(@NotNull StringsUser sender) {
        Set<StringsUser> members = this.getMembers();
        if (members.contains(sender)) {
            return this.filterMutesAndIgnores(sender, this.universalSet());
        }
        Player player = User.of(sender).player();
        World senderWorld = player.getWorld();
        HashSet<StringsUser> recipients = new HashSet<StringsUser>(members);
        UserUtil userUtil = this.getUserUtil();
        Location senderLocation = player.getLocation();
        for (Player p : senderWorld.getPlayers()) {
            Location pLocation = p.getLocation();
            if (!(senderLocation.distanceSquared(pLocation) < this.distanceSquared)) continue;
            recipients.add(userUtil.getUser(p));
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.hasPermission("strings.channels." + this.getName() + ".receive")) continue;
            recipients.add(userUtil.getUser(p));
        }
        return this.filterMutesAndIgnores(sender, recipients);
    }

    @Override
    @NotNull
    public Type getType() {
        return Type.PROXIMITY;
    }

    @Override
    public Map<String, Object> getData() {
        Map<String, Object> map = super.getData();
        map.put("distance", String.valueOf(this.distance));
        return map;
    }

    @Override
    public double getProximity() {
        return this.distance;
    }

    @Override
    public void setProximity(@Range(from=0L, to=0x7FFFFFFFL) double proximity) {
        this.distance = proximity;
        this.distanceSquared = this.distance * this.distance;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return IDENTIFIER;
    }
}

