/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.channel.local;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.StringsPlatform;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.channel.Type;
import com.pedestriamc.strings.api.channel.data.LocalChannelBuilder;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.channel.local.AbstractLocalChannel;
import com.pedestriamc.strings.impl.BukkitMessenger;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.Unmodifiable;

public class StrictProximityChannel
extends AbstractLocalChannel {
    public static final String IDENTIFIER = "proximity_strict";
    private @Range(from=0L, to=0x7FFFFFFFL) double distance;
    private double distanceSquared;
    private final Channel defaultChannel;
    private final BukkitMessenger messenger;

    public StrictProximityChannel(StringsPlatform plugin, LocalChannelBuilder<?> builder) {
        this((Strings)plugin, builder);
    }

    public StrictProximityChannel(@NotNull Strings strings, @NotNull LocalChannelBuilder<?> builder) {
        super(strings, builder);
        this.defaultChannel = strings.getChannelLoader().getChannel("default");
        this.messenger = strings.getMessenger();
    }

    @Override
    public void sendMessage(@NotNull StringsUser user, @NotNull String message) {
        if (this.containsInScope(user)) {
            super.sendMessage(user, message);
        } else {
            this.defaultChannel.sendMessage(user, message);
            this.messenger.sendMessage(Message.INELIGIBLE_SENDER, this.getPlaceholders(), (CommandSender)User.playerOf(user));
        }
    }

    @Override
    @NotNull
    public Set<StringsUser> getRecipients(@NotNull StringsUser sender) {
        Player player = User.playerOf(sender);
        World senderWorld = player.getWorld();
        UserUtil userUtil = this.getUserUtil();
        HashSet<StringsUser> recipients = new HashSet<StringsUser>(this.getMonitors());
        Location senderLocation = player.getLocation();
        for (Player p : senderWorld.getPlayers()) {
            Location pLocation = p.getLocation();
            if (!(senderLocation.distanceSquared(pLocation) < this.distanceSquared)) continue;
            recipients.add(userUtil.getUser(p));
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.hasPermission("strings.channels." + this.getName() + ".receive")) continue;
            recipients.add(userUtil.getUser(p));
        }
        return this.filterMutesAndIgnores(sender, recipients);
    }

    @Override
    @NotNull
    public Type getType() {
        return Type.PROXIMITY;
    }

    @Contract(value=" -> new")
    @NotNull
    private @Unmodifiable Map<String, String> getPlaceholders() {
        return Map.of("{channel}", this.getName());
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public @Range(from=-1L, to=0x7FFFFFFFL) double getProximity() throws UnsupportedOperationException {
        return this.distance;
    }

    @Override
    public void setProximity(@Range(from=-1L, to=0x7FFFFFFFL) double proximity) throws UnsupportedOperationException {
        this.distance = proximity;
        this.distanceSquared = proximity * proximity;
    }
}

