/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.channel.local;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.StringsPlatform;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.channel.Type;
import com.pedestriamc.strings.api.channel.data.LocalChannelBuilder;
import com.pedestriamc.strings.api.channel.local.Locality;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.channel.local.AbstractLocalChannel;
import com.pedestriamc.strings.impl.BukkitMessenger;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class StrictWorldChannel
extends AbstractLocalChannel {
    public static final String IDENTIFIER = "world_strict";
    private final Channel defaultChannel;
    private final BukkitMessenger messenger;

    public StrictWorldChannel(StringsPlatform plugin, LocalChannelBuilder<?> builder) {
        this((Strings)plugin, builder);
    }

    public StrictWorldChannel(@NotNull Strings strings, @NotNull LocalChannelBuilder<?> builder) {
        super(strings, builder);
        this.defaultChannel = strings.getChannelLoader().getChannel("default");
        this.messenger = strings.getMessenger();
    }

    @Override
    public void sendMessage(@NotNull StringsUser user, @NotNull String message) {
        if (this.containsInScope(user)) {
            super.sendMessage(user, message);
        } else {
            this.defaultChannel.sendMessage(user, message);
            this.messenger.sendMessage(Message.INELIGIBLE_SENDER, this.getPlaceholders(), (CommandSender)User.playerOf(user));
        }
    }

    @Override
    @NotNull
    public Set<StringsUser> getRecipients(@NotNull StringsUser sender) {
        UserUtil userUtil = this.getUserUtil();
        HashSet<StringsUser> recipients = new HashSet<StringsUser>(this.getMonitors());
        for (World w : Locality.convertToWorlds(this.getWorlds())) {
            recipients.addAll(this.convertToUsers(w.getPlayers()));
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.hasPermission("strings.channels." + this.getName() + ".receive")) continue;
            recipients.add(userUtil.getUser(p));
        }
        return this.filterMutesAndIgnores(sender, recipients);
    }

    @Override
    @NotNull
    public Type getType() {
        return Type.WORLD;
    }

    @Contract(value=" -> new")
    @NotNull
    private @Unmodifiable Map<String, String> getPlaceholders() {
        return Map.of("{channel}", this.getName());
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public double getProximity() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getProximity() called on WorldChannel instance, which is unsupported.");
    }

    @Override
    public void setProximity(double proximity) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setProximity() called on WorldChannel instance, which is unsupported.");
    }
}

