/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.channel.local;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.StringsPlatform;
import com.pedestriamc.strings.api.channel.Type;
import com.pedestriamc.strings.api.channel.data.LocalChannelBuilder;
import com.pedestriamc.strings.api.channel.local.Locality;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.channel.local.AbstractLocalChannel;
import com.pedestriamc.strings.user.util.UserUtil;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class WorldChannel
extends AbstractLocalChannel {
    public static final String IDENTIFIER = "world";

    public WorldChannel(StringsPlatform plugin, LocalChannelBuilder<?> builder) {
        this((Strings)plugin, builder);
    }

    public WorldChannel(@NotNull Strings strings, @NotNull LocalChannelBuilder<?> builder) {
        super(strings, builder);
    }

    @Override
    @NotNull
    public Set<StringsUser> getRecipients(@NotNull StringsUser sender) {
        HashSet<StringsUser> recipients = new HashSet<StringsUser>();
        UserUtil userUtil = this.getUserUtil();
        for (World w : Locality.convertToWorlds(this.getWorlds())) {
            recipients.addAll(this.convertToUsers(w.getPlayers()));
        }
        recipients.addAll(this.getMembers());
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.hasPermission("strings.channels." + this.getName() + ".receive")) continue;
            recipients.add(userUtil.getUser(p));
        }
        return this.filterMutesAndIgnores(sender, recipients);
    }

    @Override
    @NotNull
    public Type getType() {
        return Type.WORLD;
    }

    @Override
    public double getProximity() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getProximity() called on WorldChannel instance, which is unsupported.");
    }

    @Override
    public void setProximity(double proximity) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setProximity() called on WorldChannel instance, which is unsupported.");
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return IDENTIFIER;
    }
}

