/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.chat;

import com.google.common.base.Preconditions;
import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.channel.Membership;
import com.pedestriamc.strings.api.channel.data.AbstractChannelBuilder;
import com.pedestriamc.strings.api.channel.data.ChannelBuilder;
import com.pedestriamc.strings.api.channel.data.LocalChannelBuilder;
import com.pedestriamc.strings.api.channel.local.Locality;
import com.pedestriamc.strings.api.settings.Option;
import com.pedestriamc.strings.api.text.format.StringsTextColor;
import com.pedestriamc.strings.channel.DefaultChannel;
import com.pedestriamc.strings.channel.HelpOPChannel;
import com.pedestriamc.strings.channel.SocialSpyChannel;
import com.pedestriamc.strings.chat.ChannelManager;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

class ChannelFileReader {
    private static final Set<String> LEGAL_TYPES = Set.of("stringchannel", "world", "world_strict", "proximity", "proximity_strict", "helpop");
    private static final Set<String> LOCAL_TYPES = Set.of("world", "world_strict", "proximity", "proximity_strict");
    @NotNull
    private final Strings strings;
    @NotNull
    private final ChannelManager manager;

    static void loadChannels(@NotNull Strings strings, @NotNull FileConfiguration config, @NotNull ChannelManager manager) {
        new ChannelFileReader(strings, config, manager);
    }

    private ChannelFileReader(@NotNull Strings strings, @NotNull FileConfiguration config, @NotNull ChannelManager manager) {
        this.strings = strings;
        this.manager = manager;
        ConfigurationSection channels = config.getConfigurationSection("channels");
        if (channels == null) {
            strings.warning("No Channels defined in channels.yml, disabling plugin.");
            strings.getServer().getPluginManager().disablePlugin((Plugin)strings);
            return;
        }
        this.read(channels);
        this.registerDefaults();
    }

    private void registerDefaults() {
        if (this.manager.getChannel("global") == null) {
            this.registerGlobal();
        }
        if (this.manager.getChannel("helpop") == null) {
            this.registerHelpOp();
        }
        String socialSpyFormat = this.strings.getConfiguration().getString(Option.Text.SOCIAL_SPY_FORMAT);
        this.manager.register(new SocialSpyChannel(this.strings.getPlayerDirectMessenger(), socialSpyFormat));
        this.manager.register(new DefaultChannel(this.manager));
    }

    private void read(@NotNull ConfigurationSection channels) {
        for (String name : channels.getKeys(false)) {
            ConfigurationSection section = channels.getConfigurationSection(name);
            if (section != null) {
                this.strings.info("Loading channel '" + name + "'");
                try {
                    this.loadChannel(name, section);
                }
                catch (Exception e) {
                    this.strings.warning("An error occurred while loading channel '" + name + "':");
                    this.strings.warning(e.getMessage());
                }
                continue;
            }
            this.strings.warning("An error occurred while loading channel '" + name + "'");
        }
    }

    private void loadChannel(@NotNull String name, @NotNull ConfigurationSection section) {
        AbstractChannelBuilder builder;
        String format = section.getString("format");
        Preconditions.checkNotNull((Object)format, (Object)"Channel format cannot be null.");
        String type = this.getTypeString(section);
        Membership membership = this.getMembership(section);
        if (this.isLocal(type)) {
            LocalChannelBuilder temp = Channel.localBuilder(name, format, membership, this.loadWorlds(section));
            if (this.isProximity(type)) {
                temp.setDistance(this.getDistance(section));
            }
            builder = temp;
        } else {
            builder = Channel.builder(name, format, membership);
        }
        builder.setDefaultColor(section.getString("default-color", StringsTextColor.WHITE.toString())).setDoCooldown(section.getBoolean("cooldown", false)).setDoProfanityFilter(section.getBoolean("filter-profanity", false)).setDoUrlFilter(section.getBoolean("block-urls", false)).setCallEvent(section.getBoolean("call-event", true)).setPriority(section.getInt("priority", -1)).setBroadcastFormat(section.getString("broadcast-format", "&8[&cBroadcast&8] &f{message}"));
        Channel channel = builder.build(type);
        this.manager.register(channel);
        String symbol = section.getString("symbol");
        if (symbol != null) {
            this.manager.addChannelSymbol(symbol, channel);
        }
    }

    @NotNull
    private Membership getMembership(@NotNull ConfigurationSection section) {
        String membershipString = section.getString("membership");
        Preconditions.checkNotNull((Object)membershipString, (Object)"Channel membership cannot be null.");
        try {
            return Membership.valueOf(membershipString.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid channel membership: " + membershipString);
        }
    }

    @NotNull
    private String getTypeString(@NotNull ConfigurationSection section) {
        String type = section.getString("type");
        Preconditions.checkNotNull((Object)type, (Object)"Channel type cannot be null.");
        if (LEGAL_TYPES.contains(type.toLowerCase(Locale.ROOT))) {
            return type;
        }
        throw new IllegalArgumentException("Invalid channel type: '" + type + "'");
    }

    private boolean isProximity(@NotNull String type) {
        return (type = type.toLowerCase(Locale.ROOT)).equals("proximity") || type.equals("proximity_strict");
    }

    private double getDistance(@NotNull ConfigurationSection section) {
        double distance = section.getDouble("distance");
        if (distance < 1.0) {
            throw new IllegalArgumentException("ProximityChannels must have a positive distance value.");
        }
        return distance;
    }

    @NotNull
    private Set<Locality<World>> loadWorlds(@NotNull ConfigurationSection section) {
        HashSet<Locality<World>> worlds = new HashSet<Locality<World>>();
        String legacyWorldName = section.getString("world");
        if (legacyWorldName != null) {
            World world = Bukkit.getWorld((String)legacyWorldName);
            if (world != null) {
                worlds.add(Locality.of(world));
            } else {
                this.strings.warning("Unknown world '" + legacyWorldName + "' defined, skipping...");
            }
        }
        List list = section.getStringList("worlds");
        for (String str : list) {
            World world = Bukkit.getWorld((String)str);
            if (world != null) {
                worlds.add(Locality.of(world));
                continue;
            }
            this.strings.warning("Unknown world '" + str + "' defined, skipping...");
        }
        if (worlds.isEmpty()) {
            throw new IllegalArgumentException("No worlds found, LocalChannels must define one or more worlds.");
        }
        return worlds;
    }

    private boolean isLocal(@NotNull String type) {
        return LOCAL_TYPES.contains(type.toLowerCase(Locale.ROOT));
    }

    private void registerGlobal() {
        try {
            this.manager.register(((ChannelBuilder)((ChannelBuilder)((ChannelBuilder)((ChannelBuilder)((ChannelBuilder)((ChannelBuilder)Channel.builder("global", "{prefix}{displayname}{suffix} &7\u00bb {message}", Membership.DEFAULT).setDefaultColor("&f")).setDoCooldown(false)).setDoProfanityFilter(false)).setDoUrlFilter(false)).setCallEvent(true)).setPriority(-1)).build("stringchannel"));
        }
        catch (Exception e) {
            this.strings.warning("An error occurred while loading global channel fallback");
            this.strings.warning(e.getMessage());
        }
    }

    private void registerHelpOp() {
        this.manager.register(new HelpOPChannel(this.strings, "&8[&4HelpOP&8] &f{displayname} &7\u00bb {message}", false, false, false));
    }
}

