/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.chat;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.channel.ChannelLoader;
import com.pedestriamc.strings.api.channel.Type;
import com.pedestriamc.strings.channel.DefaultChannel;
import com.pedestriamc.strings.chat.ChannelFileReader;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChannelManager
implements ChannelLoader {
    @NotNull
    private final Strings strings;
    private final HashMap<String, Channel> channels;
    private final FileConfiguration config;
    private final HashMap<String, Channel> channelSymbols;
    private final TreeSet<Channel> priorityChannels;
    private final UserUtil userUtil;

    public ChannelManager(@NotNull Strings strings) {
        this.strings = strings;
        this.channels = new HashMap();
        this.config = strings.files().getChannelsFileConfig();
        this.channelSymbols = new HashMap();
        this.priorityChannels = new TreeSet();
        this.userUtil = strings.users();
    }

    public void loadChannels() {
        ChannelFileReader.loadChannels(this.strings, this.config, this);
    }

    @Override
    @Nullable
    public Channel getChannel(@NotNull String name) {
        Objects.requireNonNull(name);
        Channel channel = this.channels.get(name);
        if (channel == null) {
            this.refreshChannelMap();
            channel = this.channels.get(name);
        }
        if (channel != null && !channel.getName().equals(name)) {
            this.refreshChannelMap();
            channel = this.channels.get(name);
        }
        return channel;
    }

    private void refreshChannelMap() {
        Set<Channel> channelSet = this.getChannels();
        this.channels.clear();
        for (Channel channel : channelSet) {
            Channel previous = this.channels.putIfAbsent(channel.getName(), channel);
            if (previous == null) continue;
            this.strings.warning("Two or more Channels are registered with the name '" + channel.getName() + "'.");
            this.strings.warning("Channel " + channel.getName() + " with type identifier '" + channel.getIdentifier() + "' is being skipped.");
        }
    }

    @Override
    @NotNull
    public Set<Channel> getChannels() {
        return new HashSet<Channel>(this.channels.values());
    }

    @Override
    public void register(@NotNull Channel channel) {
        Objects.requireNonNull(channel, "Channel cannot be null");
        String channelName = channel.getName();
        if (this.channels.containsKey(channelName)) {
            this.strings.warning("Failed to register Channel.");
            this.strings.warning("A Channel with the name '" + channelName + "' already exists, channels with the same name cannot be registered.");
            return;
        }
        if (channel.getPriority() > -1) {
            this.priorityChannels.add(channel);
        }
        this.channels.put(channel.getName(), channel);
        this.strings.info("Channel '" + channel.getName() + "' registered.");
    }

    @Override
    public void unregister(@NotNull Channel channel) {
        Objects.requireNonNull(channel, "Channel cannot be null");
        if (!this.channels.containsKey(channel.getName())) {
            throw new NoSuchElementException("Channel '" + channel.getName() + "' is not registered.");
        }
        Set<User> users = this.strings.users().getUsers();
        Channel defaultChannel = Objects.requireNonNullElseGet(this.getChannel("default"), () -> {
            DefaultChannel c = new DefaultChannel(this);
            this.register(c);
            return c;
        });
        for (User user : users) {
            if (!user.getActiveChannel().equals(channel)) continue;
            user.setActiveChannel(defaultChannel);
            user.leaveChannel(channel);
            this.userUtil.saveUser(user);
        }
        for (Map.Entry entry : this.channelSymbols.entrySet()) {
            if (!((Channel)entry.getValue()).equals(channel)) continue;
            this.channelSymbols.remove(entry.getKey());
        }
        this.priorityChannels.remove(channel);
        this.channels.remove(channel.getName());
    }

    @NotNull
    public Channel getDefaultChannel() {
        Channel defaultChannel = this.channels.get("default");
        if (defaultChannel == null) {
            defaultChannel = new DefaultChannel(this);
            this.register(defaultChannel);
        }
        return defaultChannel;
    }

    @Override
    public void save(@NotNull Channel channel) {
        Objects.requireNonNull(channel, "Cannot save null channel");
        if (channel.getType() == Type.PROTECTED) {
            this.strings.info("Unable to save protected channels, they must be modified in channels.yml");
            return;
        }
        Map<String, Object> dataMap = channel.getData();
        String channelName = channel.getName();
        ConfigurationSection channelSection = this.config.getConfigurationSection("channels." + channelName);
        if (channelSection == null) {
            channelSection = this.config.createSection("channels." + channelName);
        }
        dataMap.forEach((arg_0, arg_1) -> ((ConfigurationSection)channelSection).set(arg_0, arg_1));
        this.strings.files().saveChannelsFile();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public Map<String, Channel> getChannelSymbols() {
        return new HashMap<String, Channel>(this.channelSymbols);
    }

    public void addChannelSymbol(String symbol, Channel channel) {
        this.channelSymbols.put(symbol, channel);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public SortedSet<Channel> getSortedChannelSet() {
        return new TreeSet<Channel>((SortedSet<Channel>)this.priorityChannels);
    }
}

