/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.chat;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.settings.Option;
import com.pedestriamc.strings.configuration.Configuration;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import java.util.Set;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.wiicart.commands.permission.Permissions;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public final class Mentioner {
    private final UserUtil userUtil;
    private final float pitch;
    private final float volume;
    private final String format;
    private Sound sound;

    public Mentioner(@NotNull Strings strings) {
        this.userUtil = strings.users();
        Configuration config = strings.getConfiguration();
        this.pitch = config.getFloat(Option.Double.MENTION_PITCH);
        this.volume = config.getFloat(Option.Double.MENTION_VOLUME);
        this.format = config.getColored(Option.Text.MENTION_TEXT_ACTION_BAR);
        try {
            this.sound = Sound.valueOf((String)config.getString(Option.Text.MENTION_SOUND));
        }
        catch (IllegalArgumentException e) {
            strings.warning("Invalid sound-type for mentions in config.yml, defaulting to: BLOCK_NOTE_BLOCK_PLING");
            this.sound = Sound.BLOCK_NOTE_BLOCK_PLING;
        }
    }

    public static boolean hasMentionPermission(@NotNull Player player) {
        return Permissions.anyOfOrAdmin((Permissible)player, "strings.*", "strings.mention", "strings.mention.*", "strings.mention.all");
    }

    public void mention(@NotNull Player player, @NotNull Player sender) {
        if (!this.userUtil.getUser(player).isMentionsEnabled()) {
            return;
        }
        String str = this.format;
        str = str.replace("%sender%", sender.getName());
        this.sendMention(player, str);
    }

    public void mention(@NotNull User user, @NotNull User sender) {
        this.mention(user.player(), sender.player());
    }

    public void mention(@NotNull Set<Player> group, @NotNull Player sender) {
        group.removeIf(p -> !this.userUtil.getUser((Player)p).isMentionsEnabled());
        String str = this.format;
        str = str.replace("%sender%", sender.getName());
        for (Player p2 : group) {
            this.sendMention(p2, str);
        }
    }

    public void sendMention(@NotNull Player player, @NotNull String message) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
        player.playSound(player.getLocation(), this.sound, this.volume, this.pitch);
    }
}

