/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.chat;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.settings.Option;
import com.pedestriamc.strings.configuration.Configuration;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import java.awt.Color;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import net.wiicart.commands.permission.Permissions;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class MessageProcessor {
    private static final Pattern HEX_PATTERN = Pattern.compile("&#[0-9A-Fa-f]{6}");
    private final UserUtil userUtil;
    private final Channel channel;
    private final Logger logger;
    private final boolean usingPlaceholderAPI;
    private final boolean processingMessagePlaceholders;
    private final boolean parsingMessageChatColors;
    private final String mentionColor;

    public MessageProcessor(@NotNull Strings strings, Channel channel) {
        this.channel = channel;
        this.userUtil = strings.users();
        this.logger = strings.getLogger();
        Configuration config = strings.getConfiguration();
        this.usingPlaceholderAPI = strings.isUsingPlaceholderAPI();
        this.processingMessagePlaceholders = config.getBoolean(Option.Bool.PROCESS_PLACEHOLDERS) && this.usingPlaceholderAPI;
        this.parsingMessageChatColors = config.getBoolean(Option.Bool.PROCESS_CHATCOLOR);
        this.mentionColor = config.getColored(Option.Text.MENTION_COLOR);
    }

    public String generateTemplate(Player player) {
        User user = this.userUtil.getUser(player);
        return this.generateTemplateNonChatColor(player).replace("{message}", user.getChatColor(this.channel) + "{message}");
    }

    public String generateTemplateNonChatColor(Player player) {
        User user = this.userUtil.getUser(player);
        String template = this.channel.getFormat();
        template = template.replace("{prefix}", user.getPrefix()).replace("{suffix}", user.getSuffix()).replace("{displayname}", user.getDisplayName());
        if (this.usingPlaceholderAPI) {
            template = this.setPlaceholders(player, template);
        }
        template = this.setHex(template);
        template = ChatColor.translateAlternateColorCodes((char)'&', (String)template);
        return template;
    }

    public String processMessage(Player sender, String message) {
        if (this.shouldReplacePlaceholders(sender)) {
            message = this.setPlaceholders(sender, message);
        }
        if (this.shouldColorMessage(sender)) {
            message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        }
        return message;
    }

    public String processMentions(Player sender, @NotNull String str) {
        if (!str.contains("@")) {
            return str;
        }
        String chatColor = this.userUtil.getUser(sender).getChatColor(this.channel);
        String[] splitStr = str.split("((?=@))");
        StringBuilder sb = new StringBuilder();
        for (String segment : splitStr) {
            if (!segment.contains("@")) {
                sb.append(chatColor).append(segment);
                continue;
            }
            if (sender.hasPermission("strings.mention.all") && segment.contains("@everyone")) {
                segment = segment.replace("@everyone", this.mentionColor + "@everyone" + String.valueOf(ChatColor.RESET) + chatColor);
            }
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!this.userUtil.getUser(p).isMentionsEnabled() || !segment.contains(p.getName())) continue;
                String original = "@" + p.getName();
                String replacement = this.mentionColor + "@" + p.getName() + String.valueOf(ChatColor.RESET) + chatColor;
                segment = segment.replace(original, replacement);
            }
            sb.append(segment);
        }
        return sb.toString();
    }

    @NotNull
    private String setHex(@NotNull String string) {
        Matcher matcher = HEX_PATTERN.matcher(string);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            try {
                String stringHex = matcher.group();
                Color color = Color.decode(stringHex.substring(1));
                ChatColor colorCode = ChatColor.of((Color)color);
                matcher.appendReplacement(sb, colorCode.toString());
            }
            catch (NumberFormatException e) {
                matcher.appendReplacement(sb, matcher.group());
            }
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected String setPlaceholders(Player sender, String str) {
        try {
            return PlaceholderAPI.setPlaceholders((Player)sender, (String)str);
        }
        catch (NoClassDefFoundError e) {
            this.logger.warning("Failed to set placeholders for message from " + sender.getName() + ".");
            return str;
        }
    }

    private boolean shouldReplacePlaceholders(Player sender) {
        return this.processingMessagePlaceholders && Permissions.anyOfOrAdmin((Permissible)sender, "strings.*", "strings.chat.*", "strings.chat.placeholdermsg");
    }

    private boolean shouldColorMessage(Player sender) {
        return this.parsingMessageChatColors && Permissions.anyOfOrAdmin((Permissible)sender, "strings.*", "strings.chat.*", "strings.chat.colormsg");
    }

    protected User getUser(Player player) {
        return this.userUtil.getUser(player);
    }

    protected Channel getChannel() {
        return this.channel;
    }
}

