/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.chat.paper;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.settings.Option;
import com.pedestriamc.strings.api.text.format.ComponentConverter;
import com.pedestriamc.strings.api.text.format.StringsComponent;
import com.pedestriamc.strings.chat.Mentioner;
import com.pedestriamc.strings.chat.MessageProcessor;
import com.pedestriamc.strings.user.User;
import io.papermc.paper.chat.ChatRenderer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextReplacementConfig;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ChannelChatRenderer
extends MessageProcessor
implements ChatRenderer {
    private final boolean mentionsEnabled;

    public ChannelChatRenderer(@NotNull Strings strings, @NotNull Channel channel) {
        super(strings, channel);
        this.mentionsEnabled = strings.getConfiguration().getBoolean(Option.Bool.ENABLE_MENTIONS);
    }

    @NotNull
    public Component render(@NotNull Player source, @NotNull Component sourceDisplayName, @NotNull Component message, @NotNull Audience viewer) {
        String template = this.generateTemplateNonChatColor(source);
        Component component = ComponentConverter.fromString(template);
        return this.setPlaceholder(component, "{message}", this.processMessage(source, message));
    }

    @NotNull
    private Component processMessage(@NotNull Player source, @NotNull Component message) {
        User sourceUser = this.getUser(source);
        String msg = ComponentConverter.toString(message);
        msg = super.processMessage(source, msg);
        if (this.mentionsEnabled && Mentioner.hasMentionPermission(source)) {
            msg = this.processMentions(source, msg);
        }
        return sourceUser.getChatColorComponent().append(StringsComponent.fromString(msg)).asComponent();
    }

    @NotNull
    private Component setPlaceholder(@NotNull Component component, @NotNull String original, @NotNull String replacement) {
        return component.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(original).replacement(replacement).build());
    }

    @NotNull
    private Component setPlaceholder(@NotNull Component component, @NotNull String original, @NotNull Component replacement) {
        return component.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(original).replacement(replacement).build());
    }
}

