/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.settings.Option;
import com.pedestriamc.strings.impl.BukkitMessenger;
import me.clip.placeholderapi.PlaceholderAPI;
import net.wiicart.commands.permission.Permissions;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public final class BroadcastCommand
implements CommandExecutor {
    @NotNull
    private final Strings strings;
    @NotNull
    private final String broadcastFormat;
    @NotNull
    private final BukkitMessenger messenger;
    private final boolean usePAPI;

    public BroadcastCommand(@NotNull Strings strings) {
        this.strings = strings;
        this.broadcastFormat = strings.getConfiguration().getString(Option.Text.BROADCAST_FORMAT);
        this.usePAPI = strings.isUsingPlaceholderAPI();
        this.messenger = strings.getMessenger();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!Permissions.anyOfOrAdmin((Permissible)sender, "strings.*", "strings.chat.*", "strings.chat.broadcast")) {
            this.messenger.sendMessage(Message.NO_PERMS, sender);
            return true;
        }
        StringBuilder builder = new StringBuilder(this.broadcastFormat);
        if (sender.hasPermission("strings.chat.placeholdermsg") && this.usePAPI && sender instanceof Player) {
            Player p = (Player)sender;
            PlaceholderAPI.setPlaceholders((Player)p, (String)builder.toString());
        }
        for (Player arg : args) {
            builder.append((String)arg);
            builder.append(" ");
        }
        String broadcast = builder.toString();
        broadcast = ChatColor.translateAlternateColorCodes((char)'&', (String)broadcast);
        this.strings.getServer().broadcastMessage(broadcast);
        return true;
    }
}

