/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.text.format.Element;
import com.pedestriamc.strings.api.text.format.StringsComponent;
import com.pedestriamc.strings.api.text.format.StringsTextColor;
import com.pedestriamc.strings.api.text.format.StringsTextDecoration;
import com.pedestriamc.strings.impl.BukkitMessenger;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import java.awt.Color;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class ChatColorCommand
implements CommandExecutor {
    private static final Map<String, StringsTextColor> colorMap = Map.ofEntries(new AbstractMap.SimpleEntry<String, StringsTextColor>("BLACK", StringsTextColor.BLACK), new AbstractMap.SimpleEntry<String, StringsTextColor>("DARKBLUE", StringsTextColor.DARK_BLUE), new AbstractMap.SimpleEntry<String, StringsTextColor>("DARKGREEN", StringsTextColor.DARK_GREEN), new AbstractMap.SimpleEntry<String, StringsTextColor>("DARKAQUA", StringsTextColor.DARK_AQUA), new AbstractMap.SimpleEntry<String, StringsTextColor>("DARKRED", StringsTextColor.DARK_RED), new AbstractMap.SimpleEntry<String, StringsTextColor>("DARKPURPLE", StringsTextColor.DARK_PURPLE), new AbstractMap.SimpleEntry<String, StringsTextColor>("GOLD", StringsTextColor.GOLD), new AbstractMap.SimpleEntry<String, StringsTextColor>("GRAY", StringsTextColor.GRAY), new AbstractMap.SimpleEntry<String, StringsTextColor>("DARKGRAY", StringsTextColor.DARK_GRAY), new AbstractMap.SimpleEntry<String, StringsTextColor>("BLUE", StringsTextColor.BLUE), new AbstractMap.SimpleEntry<String, StringsTextColor>("GREEN", StringsTextColor.GREEN), new AbstractMap.SimpleEntry<String, StringsTextColor>("AQUA", StringsTextColor.AQUA), new AbstractMap.SimpleEntry<String, StringsTextColor>("RED", StringsTextColor.RED), new AbstractMap.SimpleEntry<String, StringsTextColor>("LIGHTPURPLE", StringsTextColor.PINK), new AbstractMap.SimpleEntry<String, StringsTextColor>("YELLOW", StringsTextColor.YELLOW), new AbstractMap.SimpleEntry<String, StringsTextColor>("WHITE", StringsTextColor.WHITE));
    private static final Map<String, StringsTextDecoration> styleMap = Map.of("BOLD", StringsTextDecoration.BOLD, "UNDERLINE", StringsTextDecoration.UNDERLINE, "ITALIC", StringsTextDecoration.ITALIC, "ITALICS", StringsTextDecoration.ITALIC, "STRIKETHROUGH", StringsTextDecoration.STRIKETHROUGH, "STRIKE", StringsTextDecoration.STRIKETHROUGH, "MAGIC", StringsTextDecoration.MAGIC);
    private final Strings strings;
    private final UserUtil userUtil;
    private final BukkitMessenger messenger;

    public ChatColorCommand(@NotNull Strings strings) {
        this.strings = strings;
        this.userUtil = strings.users();
        this.messenger = strings.getMessenger();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender.hasPermission("strings.chat.chatcolor") || sender.hasPermission("strings.chat.*") || sender.hasPermission("strings.*"))) {
            this.messenger.sendMessage(Message.NO_PERMS, sender);
            return true;
        }
        if (args.length == 0) {
            this.messenger.sendMessage(Message.INSUFFICIENT_ARGS, sender);
            return true;
        }
        if (args.length > 7) {
            this.messenger.sendMessage(Message.TOO_MANY_ARGS, sender);
            return true;
        }
        Player player = Bukkit.getPlayer((String)args[args.length - 1]);
        if (sender instanceof ConsoleCommandSender && player == null) {
            this.messenger.sendMessage(Message.SERVER_MUST_SPECIFY_PLAYER, sender);
            return true;
        }
        if (player != null) {
            if (!sender.hasPermission("strings.chat.chatcolor.other")) {
                this.messenger.sendMessage(Message.NO_PERMS, sender);
                return true;
            }
        } else {
            player = (Player)sender;
        }
        User user = this.strings.users().getUser(player);
        if (args.length == 1 && args[0].equalsIgnoreCase("reset")) {
            user.setChatColorComponent(StringsComponent.of(new Element[0]));
            this.userUtil.saveUser(user);
            this.messenger.sendMessage(Message.CHATCOLOR_SET, Map.of("{color}", user.getChatColor() + "this", "{player}", player.getName()), (CommandSender)player);
            return true;
        }
        ArrayList elements = new ArrayList();
        boolean hasColor = false;
        for (String arg : args) {
            String pattern = "#(?:[0-9a-fA-F]{6}|[0-9a-fA-F]{3})";
            if (colorMap.containsKey(arg.toUpperCase())) {
                if (hasColor) {
                    this.messenger.sendMessage(Message.ONE_COLOR, sender);
                    return true;
                }
                elements.add(colorMap.get(arg.toUpperCase()));
                hasColor = true;
                continue;
            }
            if (styleMap.containsKey(arg.toUpperCase())) {
                elements.add(styleMap.get(arg.toUpperCase()));
                continue;
            }
            if (!arg.matches(pattern)) continue;
            StringsTextColor color = StringsTextColor.of(new Color(Integer.parseInt(arg.substring(1), 16)));
            elements.add(color);
            hasColor = true;
        }
        if (!hasColor) {
            this.messenger.sendMessage(Message.UNKNOWN_COLOR, sender);
            return true;
        }
        user.setChatColorComponent(StringsComponent.of(elements));
        this.userUtil.saveUser(user);
        if (!player.equals((Object)sender)) {
            this.messenger.sendMessage(Message.CHATCOLOR_SET_OTHER, Map.of("{color}", String.valueOf(user.getChatColorComponent()) + "this", "{player}", player.getName()), sender);
        }
        this.messenger.sendMessage(Message.CHATCOLOR_SET, Map.of("{color}", String.valueOf(user.getChatColorComponent()) + "this", "{player}", player.getName()), (CommandSender)player);
        return true;
    }
}

