/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.impl.BukkitMessenger;
import net.wiicart.commands.permission.Permissions;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public final class ClearChatCommand
implements CommandExecutor {
    @NotNull
    private final BukkitMessenger messenger;

    public ClearChatCommand(@NotNull Strings strings) {
        this.messenger = strings.getMessenger();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!Permissions.anyOfOrAdmin((Permissible)sender, "strings.*", "strings.chat.*", "strings.chat.clear")) {
            this.messenger.sendMessage(Message.NO_PERMS, sender);
            return true;
        }
        if (args.length > 1) {
            this.messenger.sendMessage(Message.TOO_MANY_ARGS, sender);
            return true;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("all")) {
                if (!Permissions.anyOfOrAdmin((Permissible)sender, "strings.*", "strings.chat.*", "strings.chat.clear")) {
                    this.messenger.sendMessage(Message.NO_PERMS, sender);
                    return true;
                }
                this.clearChatAll();
                this.messenger.sendMessage(Message.CHAT_CLEARED_ALL, sender);
            } else {
                this.messenger.sendMessage(Message.INVALID_ARGS, sender);
            }
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("[Strings] Console cannot clear it's own chat.");
            return true;
        }
        sender.sendMessage(StringUtils.repeat(" \n", 100));
        this.messenger.sendMessage(Message.CHAT_CLEARED, sender);
        return true;
    }

    private void clearChatAll() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.sendMessage(StringUtils.repeat(" \n", 100));
        }
    }
}

