/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.impl.BukkitMessenger;
import com.pedestriamc.strings.user.util.UserUtil;
import net.wiicart.commands.permission.Permissions;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public final class HelpOPCommand
implements CommandExecutor {
    private final UserUtil userUtil;
    private final Channel helpOPChannel;
    private final BukkitMessenger messenger;

    public HelpOPCommand(@NotNull Strings strings) {
        this.userUtil = strings.users();
        this.helpOPChannel = strings.getChannelLoader().getChannel("helpop");
        this.messenger = strings.getMessenger();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!Permissions.anyOfOrAdmin((Permissible)sender, "strings.*", "strings.helpop.*", "strings.helpop.use")) {
            this.messenger.sendMessage(Message.NO_PERMS, sender);
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("[Strings] This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.messenger.sendMessage(Message.INSUFFICIENT_ARGS, sender);
            return true;
        }
        StringBuilder builder = new StringBuilder();
        for (String arg : args) {
            builder.append(arg);
            builder.append(" ");
        }
        this.helpOPChannel.sendMessage(this.userUtil.getUser(player), builder.toString());
        return true;
    }
}

