/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.impl.BukkitMessenger;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import net.wiicart.commands.permission.Permissions;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public final class MentionCommand
implements CommandExecutor {
    private final BukkitMessenger messenger;
    private final UserUtil userUtil;

    public MentionCommand(Strings strings) {
        this.messenger = strings.getMessenger();
        this.userUtil = strings.users();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("[Strings] This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (!Permissions.anyOfOrAdmin((Permissible)player, "strings.*", "strings.mention.*", "strings.mention.toggle")) {
            this.messenger.sendMessage(Message.NO_PERMS, sender);
            return true;
        }
        User user = this.userUtil.getUser(player);
        if (args.length == 0) {
            if (user.isMentionsEnabled()) {
                this.disable((CommandSender)player, user);
            } else {
                this.enable((CommandSender)player, user);
            }
            return true;
        }
        if (args.length == 1) {
            String arg = args[0];
            if (arg.equalsIgnoreCase("enable") || arg.equalsIgnoreCase("on")) {
                this.enable((CommandSender)player, user);
                return true;
            }
            if (arg.equalsIgnoreCase("disable") || arg.equalsIgnoreCase("off")) {
                this.disable((CommandSender)player, user);
                return true;
            }
            this.messenger.sendMessage(Message.INVALID_ARGS, sender);
            return true;
        }
        this.messenger.sendMessage(Message.TOO_MANY_ARGS, sender);
        return true;
    }

    private void enable(CommandSender sender, @NotNull User user) {
        user.setMentionsEnabled(true);
        this.userUtil.saveUser(user);
        this.messenger.sendMessage(Message.MENTIONS_ENABLED, sender);
    }

    private void disable(CommandSender sender, @NotNull User user) {
        user.setMentionsEnabled(false);
        this.userUtil.saveUser(user);
        this.messenger.sendMessage(Message.MENTIONS_DISABLED, sender);
    }
}

