/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.impl.BukkitMessenger;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import net.wiicart.commands.permission.Permissions;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public final class SocialSpyCommand
implements CommandExecutor {
    private final BukkitMessenger messenger;
    private final UserUtil userUtil;
    private final Channel channel;

    public SocialSpyCommand(@NotNull Strings strings) {
        this.messenger = strings.getMessenger();
        this.userUtil = strings.users();
        this.channel = strings.getChannelLoader().getChannel("socialspy");
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("[Strings] This command can only be used by players");
            return true;
        }
        if (!Permissions.anyOfOrAdmin((Permissible)sender, "strings.*", "strings.socialspy")) {
            this.messenger.sendMessage(Message.NO_PERMS, sender);
            return true;
        }
        if (args.length == 0) {
            this.noArgs(sender);
            return true;
        }
        if (args.length > 1) {
            this.messenger.sendMessage(Message.TOO_MANY_ARGS, sender);
            return true;
        }
        this.determine(args[0], sender);
        return true;
    }

    private void determine(@NotNull String arg, @NotNull CommandSender sender) {
        switch (arg.toLowerCase()) {
            case "on": 
            case "true": {
                this.enableSocialSpy(sender);
                break;
            }
            case "off": 
            case "false": {
                this.disableSocialSpy(sender);
                break;
            }
            default: {
                this.noArgs(sender);
            }
        }
    }

    private void enableSocialSpy(CommandSender sender) {
        User user = this.userUtil.getUser((Player)sender);
        user.joinChannel(this.channel);
        this.userUtil.saveUser(user);
        this.messenger.sendMessage(Message.SOCIAL_SPY_ON, sender);
    }

    private void disableSocialSpy(CommandSender sender) {
        User user = this.userUtil.getUser((Player)sender);
        user.leaveChannel(this.channel);
        this.userUtil.saveUser(user);
        this.messenger.sendMessage(Message.SOCIAL_SPY_OFF, sender);
    }

    private void noArgs(CommandSender sender) {
        User user = this.userUtil.getUser((Player)sender);
        if (user.memberOf(this.channel)) {
            this.disableSocialSpy(sender);
            return;
        }
        this.enableSocialSpy(sender);
    }
}

