/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.text.format.StringsTextColor;
import com.pedestriamc.strings.commands.CartMessengerCommand;
import net.wiicart.commands.command.CartCommandExecutor;
import net.wiicart.commands.command.CommandData;
import net.wiicart.commands.command.tree.CommandTree;
import net.wiicart.commands.permission.Permissions;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class StringsCommand
extends CommandTree {
    private static final String VERSION_MESSAGE = String.valueOf(StringsTextColor.DARK_GRAY) + "[" + String.valueOf(StringsTextColor.DARK_AQUA) + "Strings" + String.valueOf(StringsTextColor.DARK_GRAY) + "] " + String.valueOf(StringsTextColor.WHITE) + "Running strings version " + String.valueOf(StringsTextColor.GREEN) + "1.6";
    private static final String RELOAD_MESSAGE = String.valueOf(StringsTextColor.DARK_GRAY) + "[" + String.valueOf(StringsTextColor.DARK_AQUA) + "Strings" + String.valueOf(StringsTextColor.DARK_GRAY) + "] " + String.valueOf(StringsTextColor.WHITE) + "Strings version " + String.valueOf(StringsTextColor.GREEN) + "1.6" + String.valueOf(StringsTextColor.WHITE) + " reloaded.";

    public StringsCommand(@NotNull Strings strings) {
        super(CommandTree.builder().executes(data -> data.sender().sendMessage(VERSION_MESSAGE)).withChild("reload", b -> b.executes(new ReloadCommand(strings))).withChild("help", b -> b.executes(new CartMessengerCommand(strings, Message.STRINGS_HELP))).build());
    }

    private static class ReloadCommand
    implements CartCommandExecutor {
        private final Strings strings;

        ReloadCommand(@NotNull Strings strings) {
            this.strings = strings;
        }

        @Override
        public void onCommand(@NotNull CommandData data) {
            if (Permissions.anyOfOrAdmin((Permissible)data.sender(), "strings.*", "strings.reload") || data.sender() instanceof ConsoleCommandSender) {
                this.strings.reload();
                data.sender().sendMessage(RELOAD_MESSAGE);
            } else {
                this.strings.getMessenger().sendMessage(Message.NO_PERMS, data.sender());
            }
        }
    }
}

