/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands.base;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.channel.Monitorable;
import com.pedestriamc.strings.api.channel.Type;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.channel.HelpOPChannel;
import com.pedestriamc.strings.commands.AbstractCommand;
import com.pedestriamc.strings.user.User;
import java.util.Map;
import net.wiicart.commands.permission.Permissions;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OneToTwoArgAbstractCommand
extends AbstractCommand {
    protected OneToTwoArgAbstractCommand(@NotNull Strings strings) {
        super(strings);
    }

    @Nullable
    protected Channel getChannel(@NotNull CommandSender sender, @NotNull String channelName) {
        Channel channel = this.getChannel(channelName);
        if (channel == null) {
            this.sendMessage(Message.UNKNOWN_CHANNEL, Map.of("{channel}", channelName), sender);
            return null;
        }
        if (channel.getType() == Type.PROTECTED && !(channel instanceof HelpOPChannel)) {
            this.sendMessage(Message.PROTECTED_CHANNEL_UNSUPPORTED_OPERATION, sender);
            return null;
        }
        return channel;
    }

    @Nullable
    protected Channel getChannelAndCheckAllows(@NotNull CommandSender sender, @NotNull String channelName) {
        Channel channel = this.getChannel(sender, channelName);
        if (channel != null && !channel.allows((Permissible)sender)) {
            this.sendMessage(Message.NO_PERMS_CHANNEL, Map.of("{channel}", channel.getName()), sender);
            return null;
        }
        return channel;
    }

    @Nullable
    protected Monitorable getMonitorable(@NotNull CommandSender sender, @NotNull Channel channel) {
        if (channel instanceof Monitorable) {
            Monitorable monitorable = (Monitorable)channel;
            return monitorable;
        }
        this.sendMessage(Message.NOT_MONITORABLE, Map.of("{channel}", channel.getName()), sender);
        return null;
    }

    protected boolean checkArgCountAndNotify(@NotNull CommandSender sender, int length) {
        return switch (length) {
            case 0 -> {
                this.sendMessage(Message.INSUFFICIENT_ARGS, sender);
                yield true;
            }
            case 1 -> {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("[Strings] You must define a player to use this command on.");
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (Permissions.anyOfOrAdmin((Permissible)sender, "strings.*", "strings.channels.*", "strings.channels.modifyplayers")) {
                    yield false;
                }
                this.sendMessage(Message.NO_PERMS_MODIFY_OTHER, sender);
                yield true;
            }
            default -> {
                this.sendMessage(Message.TOO_MANY_ARGS, sender);
                yield true;
            }
        };
    }

    protected Map<String, String> getPlaceholders(@NotNull StringsUser user, @NotNull Channel channel) {
        return Map.of("{channel}", channel.getName(), "{player}", user.getName());
    }

    protected boolean checkConditionAndNotify(boolean set, @NotNull CommandSender sender, @NotNull StringsUser target, @NotNull Channel channel, @NotNull Message single, @NotNull Message other) {
        if (set) {
            Map<String, String> placeholders = this.getPlaceholders(target, channel);
            if (sender.equals((Object)User.playerOf(target))) {
                this.sendMessage(single, placeholders, sender);
            } else {
                this.sendMessage(other, sender);
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected User getTarget(@NotNull CommandSender sender, @NotNull String[] args) {
        if (args.length == 1) {
            if (sender instanceof Player) {
                Player playerSender = (Player)sender;
                return this.getUser(playerSender);
            }
            throw new ClassCastException("If args length is 1, the sender must be a player.");
        }
        if (args.length == 2) {
            String playerName = args[1];
            Player player = Bukkit.getPlayer((String)playerName);
            if (player == null) {
                this.sendMessage(Message.INVALID_PLAYER, Map.of("{player}", playerName), sender);
                return null;
            }
            return this.getUser(player);
        }
        return null;
    }

    protected void sendAlternateMessages(@NotNull CommandSender sender, @NotNull User target, @NotNull Channel channel, @NotNull Message targetMsg, @NotNull Message otherMsg) {
        Map<String, String> placeholders = this.getPlaceholders(target, channel);
        Player targetPlayer = target.player();
        if (!sender.equals((Object)targetPlayer)) {
            this.sendMessage(otherMsg, placeholders, sender);
        }
        this.sendMessage(targetMsg, placeholders, (CommandSender)targetPlayer);
    }
}

