/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands.channel;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.commands.base.OneToTwoArgAbstractCommand;
import java.util.Arrays;
import java.util.Map;
import net.wiicart.commands.command.CartCommandExecutor;
import net.wiicart.commands.command.CommandData;
import net.wiicart.commands.permission.Permissions;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

class BroadcastCommand
extends OneToTwoArgAbstractCommand
implements CartCommandExecutor {
    BroadcastCommand(@NotNull Strings strings) {
        super(strings);
    }

    @Override
    public void onCommand(@NotNull CommandData data) {
        String[] args = data.args();
        CommandSender sender = data.sender();
        if (args.length < 2) {
            this.sendMessage(Message.INSUFFICIENT_ARGS, sender);
            return;
        }
        Channel channel = this.getChannel(sender, args[0]);
        if (channel == null) {
            return;
        }
        if (this.doesNotHaveBroadcastPermission(sender, channel)) {
            return;
        }
        String message = this.convertArgsToString(this.removeFirstArg(args));
        channel.broadcast(message);
        this.sendMessage(Message.BROADCAST_SENT, Map.of("{channel}", channel.getName()), sender);
    }

    private boolean doesNotHaveBroadcastPermission(@NotNull CommandSender sender, @NotNull Channel channel) {
        if (Permissions.anyOfOrAdmin((Permissible)sender, "strings.*", "strings.channels.*", "strings.channels." + channel.getName() + ".*", "strings.channels." + channel.getName() + ".broadcast")) {
            return false;
        }
        this.sendMessage(Message.NO_PERMS_CHANNEL_BROADCAST, Map.of("{channel}", channel.getName()), sender);
        return true;
    }

    @NotNull
    private String convertArgsToString(@NotNull String[] args) {
        return String.join((CharSequence)" ", args);
    }

    @NotNull
    private String[] removeFirstArg(@NotNull String[] args) {
        return Arrays.copyOfRange(args, 1, args.length);
    }
}

