/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands.channel;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.commands.base.OneToTwoArgAbstractCommand;
import com.pedestriamc.strings.user.User;
import net.wiicart.commands.command.CartCommandExecutor;
import net.wiicart.commands.command.CommandData;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

class JoinCommand
extends OneToTwoArgAbstractCommand
implements CartCommandExecutor {
    JoinCommand(@NotNull Strings strings) {
        super(strings);
    }

    @Override
    public void onCommand(@NotNull CommandData data) {
        CommandSender sender = data.sender();
        int length = data.args().length;
        String[] args = data.args();
        if (this.checkArgCountAndNotify(sender, length)) {
            return;
        }
        Channel channel = this.getChannelAndCheckAllows(sender, args[0]);
        if (channel == null) {
            return;
        }
        User target = this.getTarget(sender, args);
        if (target == null) {
            return;
        }
        if (this.isAlreadyMember(sender, target, channel)) {
            return;
        }
        target.joinChannel(channel);
        target.setActiveChannel(channel);
        this.saveUser(target);
        this.sendFinalMessages(sender, target, channel);
    }

    private boolean isAlreadyMember(@NotNull CommandSender sender, @NotNull StringsUser target, @NotNull Channel channel) {
        return this.checkConditionAndNotify(target.memberOf(channel), sender, target, channel, Message.ALREADY_MEMBER, Message.ALREADY_MEMBER_OTHER);
    }

    private void sendFinalMessages(@NotNull CommandSender sender, @NotNull User target, @NotNull Channel channel) {
        this.sendAlternateMessages(sender, target, channel, Message.CHANNEL_JOINED, Message.OTHER_USER_JOINED_CHANNEL);
    }
}

