/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands.channel;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.commands.base.OneToTwoArgAbstractCommand;
import com.pedestriamc.strings.user.User;
import net.wiicart.commands.command.CartCommandExecutor;
import net.wiicart.commands.command.CommandData;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

class LeaveCommand
extends OneToTwoArgAbstractCommand
implements CartCommandExecutor {
    LeaveCommand(@NotNull Strings strings) {
        super(strings);
    }

    @Override
    public void onCommand(@NotNull CommandData data) {
        String[] args;
        CommandSender sender = data.sender();
        if (this.checkArgCountAndNotify(sender, (args = data.args()).length)) {
            return;
        }
        Channel channel = this.getChannel(sender, args[0]);
        if (channel == null) {
            return;
        }
        User target = this.getTarget(sender, args);
        if (target == null) {
            return;
        }
        if (this.isNotMember(sender, target, channel)) {
            return;
        }
        target.leaveChannel(channel);
        this.saveUser(target);
        this.sendFinalMessages(sender, target, channel);
    }

    private boolean isNotMember(@NotNull CommandSender sender, @NotNull User target, @NotNull Channel channel) {
        return this.checkConditionAndNotify(!target.memberOf(channel), sender, target, channel, Message.NOT_CHANNEL_MEMBER, Message.NOT_CHANNEL_MEMBER_OTHER);
    }

    private void sendFinalMessages(@NotNull CommandSender sender, @NotNull User target, @NotNull Channel channel) {
        this.sendAlternateMessages(sender, target, channel, Message.LEFT_CHANNEL, Message.LEFT_CHANNEL_OTHER);
    }
}

