/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands.channel;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.message.MessageContext;
import com.pedestriamc.strings.commands.AbstractCommand;
import com.pedestriamc.strings.impl.MessageableAdapter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.wiicart.commands.command.CartCommandExecutor;
import net.wiicart.commands.command.CommandData;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

class ListCommand
extends AbstractCommand
implements CartCommandExecutor {
    ListCommand(@NotNull Strings strings) {
        super(strings);
    }

    @Override
    public void onCommand(@NotNull CommandData data) {
        CommandSender sender = data.sender();
        if (data.args().length > 0) {
            this.messenger().sendMessage(Message.TOO_MANY_ARGS, sender);
        }
        Set<Channel> available = this.getAllowedChannels(sender);
        MessageContext[] contexts = this.getContexts(sender, available);
        this.messenger().batchSend(contexts);
    }

    @NotNull
    private Set<Channel> getAllowedChannels(@NotNull CommandSender sender) {
        HashSet<Channel> available = new HashSet<Channel>();
        for (Channel channel : this.strings().getChannelLoader().getChannels()) {
            if (!channel.allows((Permissible)sender)) continue;
            available.add(channel);
        }
        return available;
    }

    private MessageContext[] getContexts(@NotNull CommandSender sender, @NotNull Set<Channel> available) {
        if (available.isEmpty()) {
            return new MessageContext[]{MessageContext.of(Message.NO_CHANNELS_AVAILABLE, MessageableAdapter.of(sender), true)};
        }
        MessageContext[] contexts = new MessageContext[available.size() + 1];
        contexts[0] = MessageContext.of(Message.CHANNEL_LIST_HEADER, MessageableAdapter.of(sender), false);
        int pos = 1;
        for (Channel channel : available) {
            contexts[pos] = MessageContext.of(Message.CHANNEL_LIST_ENTRY, Map.of("{channel}", channel.getName()), MessageableAdapter.of(sender), false);
            ++pos;
        }
        return contexts;
    }
}

