/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands.channel;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.channel.Monitorable;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.commands.base.OneToTwoArgAbstractCommand;
import com.pedestriamc.strings.user.User;
import java.util.Map;
import net.wiicart.commands.command.CartCommandExecutor;
import net.wiicart.commands.command.CommandData;
import net.wiicart.commands.permission.Permissions;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

class MonitorCommand
extends OneToTwoArgAbstractCommand
implements CartCommandExecutor {
    MonitorCommand(@NotNull Strings strings) {
        super(strings);
    }

    @Override
    public void onCommand(@NotNull CommandData data) {
        CommandSender sender = data.sender();
        int length = data.args().length;
        String[] args = data.args();
        if (this.checkArgCountAndNotify(sender, length)) {
            return;
        }
        Channel channel = this.getChannel(sender, args[0]);
        if (channel == null) {
            return;
        }
        Monitorable monitorable = this.getMonitorable(sender, channel);
        if (monitorable == null) {
            return;
        }
        if (this.doesNotHaveMonitorPermission(sender, monitorable)) {
            return;
        }
        User target = this.getTarget(sender, args);
        if (target == null) {
            return;
        }
        if (this.isAlreadyMonitoring(sender, target, monitorable)) {
            return;
        }
        target.monitor(monitorable);
        this.saveUser(target);
        this.sendFinalMessages(sender, target, channel);
    }

    private boolean isAlreadyMonitoring(@NotNull CommandSender sender, @NotNull StringsUser target, @NotNull Monitorable monitorable) {
        return this.checkConditionAndNotify(target.isMonitoring(monitorable), sender, target, monitorable, Message.ALREADY_MONITORING, Message.ALREADY_MONITORING);
    }

    private void sendFinalMessages(@NotNull CommandSender sender, @NotNull User target, @NotNull Channel channel) {
        this.sendAlternateMessages(sender, target, channel, Message.MONITOR_SUCCESS, Message.MONITOR_SUCCESS_OTHER);
    }

    private boolean doesNotHaveMonitorPermission(@NotNull CommandSender sender, @NotNull Monitorable monitorable) {
        if (Permissions.anyOfOrAdmin((Permissible)sender, "strings.*", "strings.channels.*", "strings.channels." + monitorable.getName() + ".*", "strings.channels." + monitorable.getName() + ".monitor")) {
            return false;
        }
        this.sendMessage(Message.NO_PERM_MONITOR, Map.of("{channel}", monitorable.getName()), sender);
        return true;
    }
}

