/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands.channel;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.commands.base.OneToTwoArgAbstractCommand;
import com.pedestriamc.strings.user.User;
import net.wiicart.commands.command.CartCommandExecutor;
import net.wiicart.commands.command.CommandData;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

class MuteCommand
extends OneToTwoArgAbstractCommand
implements CartCommandExecutor {
    MuteCommand(@NotNull Strings strings) {
        super(strings);
    }

    @Override
    public void onCommand(@NotNull CommandData data) {
        String[] args;
        CommandSender sender = data.sender();
        if (this.checkArgCountAndNotify(sender, (args = data.args()).length)) {
            return;
        }
        Channel channel = this.getChannelAndCheckAllows(sender, args[0]);
        if (channel == null) {
            return;
        }
        User target = this.getTarget(sender, args);
        if (target == null) {
            return;
        }
        if (this.isAlreadyMuted(sender, target, channel)) {
            return;
        }
        target.muteChannel(channel);
        this.saveUser(target);
        this.sendFinalMessages(sender, target, channel);
    }

    private void sendFinalMessages(@NotNull CommandSender sender, @NotNull User target, @NotNull Channel channel) {
        this.sendAlternateMessages(sender, target, channel, Message.MUTE_SUCCESS, Message.MUTE_SUCCESS_OTHER);
    }

    private boolean isAlreadyMuted(@NotNull CommandSender sender, @NotNull StringsUser target, @NotNull Channel channel) {
        return this.checkConditionAndNotify(target.hasChannelMuted(channel), sender, target, channel, Message.ALREADY_MUTED, Message.ALREADY_MUTED_OTHER);
    }
}

